/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class Ports {
    private final Map<ExposedPort, Binding[]> ports = new HashMap<ExposedPort, Binding[]>();

    public Ports() {
    }

    public Ports(ExposedPort exposedPort, Binding host) {
        this.bind(exposedPort, host);
    }

    public Ports(PortBinding ... portBindings) {
        this.add(portBindings);
    }

    public void bind(ExposedPort exposedPort, Binding binding) {
        if (this.ports.containsKey(exposedPort)) {
            Object[] bindings = this.ports.get(exposedPort);
            this.ports.put(exposedPort, (Binding[])ArrayUtils.add((Object[])bindings, (Object)binding));
        } else if (binding == null) {
            this.ports.put(exposedPort, null);
        } else {
            this.ports.put(exposedPort, new Binding[]{binding});
        }
    }

    public void add(PortBinding ... portBindings) {
        for (PortBinding binding : portBindings) {
            this.bind(binding.getExposedPort(), binding.getBinding());
        }
    }

    public String toString() {
        return this.ports.toString();
    }

    public Map<ExposedPort, Binding[]> getBindings() {
        return this.ports;
    }

    public static Binding Binding(String hostIp, Integer hostPort) {
        return new Binding(hostIp, hostPort);
    }

    public static Binding Binding(Integer hostPort) {
        return new Binding(hostPort);
    }

    public static class Serializer
    extends JsonSerializer<Ports> {
        public void serialize(Ports portBindings, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartObject();
            for (Map.Entry<ExposedPort, Binding[]> entry : portBindings.getBindings().entrySet()) {
                jsonGen.writeFieldName(entry.getKey().toString());
                if (entry.getValue() != null) {
                    jsonGen.writeStartArray();
                    for (Binding binding : entry.getValue()) {
                        jsonGen.writeStartObject();
                        jsonGen.writeStringField("HostIp", binding.getHostIp() == null ? "" : binding.getHostIp());
                        jsonGen.writeStringField("HostPort", binding.getHostPort() == null ? "" : binding.getHostPort().toString());
                        jsonGen.writeEndObject();
                    }
                    jsonGen.writeEndArray();
                    continue;
                }
                jsonGen.writeNull();
            }
            jsonGen.writeEndObject();
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Ports> {
        public Ports deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Ports out = new Ports();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry portNode = (Map.Entry)it.next();
                JsonNode bindingsArray = (JsonNode)portNode.getValue();
                if (bindingsArray.equals((Object)NullNode.getInstance())) {
                    out.bind(ExposedPort.parse((String)portNode.getKey()), null);
                    continue;
                }
                for (int i = 0; i < bindingsArray.size(); ++i) {
                    JsonNode bindingNode = bindingsArray.get(i);
                    if (bindingNode.equals((Object)NullNode.getInstance())) continue;
                    String hostIp = bindingNode.get("HostIp").textValue();
                    int hostPort = bindingNode.get("HostPort").asInt();
                    out.bind(ExposedPort.parse((String)portNode.getKey()), new Binding(hostIp, hostPort));
                }
            }
            return out;
        }
    }

    public static class Binding {
        private final String hostIp;
        private final Integer hostPort;

        public Binding(String hostIp, Integer hostPort) {
            this.hostIp = StringUtils.isEmpty((String)hostIp) ? null : hostIp;
            this.hostPort = hostPort;
        }

        public Binding(Integer hostPort) {
            this(null, hostPort);
        }

        public Binding(String hostIp) {
            this(hostIp, null);
        }

        public Binding() {
            this(null, null);
        }

        public String getHostIp() {
            return this.hostIp;
        }

        public Integer getHostPort() {
            return this.hostPort;
        }

        public static Binding parse(String serialized) throws IllegalArgumentException {
            try {
                if (serialized.isEmpty()) {
                    return new Binding();
                }
                String[] parts = serialized.split(":");
                switch (parts.length) {
                    case 2: {
                        return new Binding(parts[0], Integer.valueOf(parts[1]));
                    }
                    case 1: {
                        return parts[0].contains(".") ? new Binding(parts[0]) : new Binding(Integer.valueOf(parts[0]));
                    }
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error parsing Binding '" + serialized + "'");
            }
        }

        public String toString() {
            if (StringUtils.isEmpty((String)this.hostIp)) {
                return Integer.toString(this.hostPort);
            }
            if (this.hostPort == null) {
                return this.hostIp;
            }
            return this.hostIp + ":" + this.hostPort;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Binding) {
                Binding other = (Binding)obj;
                return new EqualsBuilder().append((Object)this.hostIp, (Object)other.getHostIp()).append((Object)this.hostPort, (Object)other.getHostPort()).isEquals();
            }
            return super.equals(obj);
        }
    }
}

