/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;

public class CertificateUtils {
    public static boolean verifyCertificatesExist(String dockerCertPath) {
        String[] files;
        for (String file : files = new String[]{"ca.pem", "cert.pem", "key.pem"}) {
            File path = new File(dockerCertPath, file);
            boolean exists = path.exists();
            if (exists) continue;
            return false;
        }
        return true;
    }

    public static KeyStore createKeyStore(String dockerCertPath) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, CertificateException, KeyStoreException {
        KeyPair keyPair = CertificateUtils.loadPrivateKey(dockerCertPath);
        Certificate privateCertificate = CertificateUtils.loadCertificate(dockerCertPath);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        keyStore.setKeyEntry("docker", keyPair.getPrivate(), "docker".toCharArray(), new Certificate[]{privateCertificate});
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore createTrustStore(String dockerCertPath) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        File caPath = new File(dockerCertPath, "ca.pem");
        BufferedReader reader = new BufferedReader(new FileReader(caPath));
        PEMParser pemParser = null;
        try {
            pemParser = new PEMParser((Reader)reader);
            X509CertificateHolder certificateHolder = (X509CertificateHolder)pemParser.readObject();
            X509Certificate caCertificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null);
            trustStore.setCertificateEntry("ca", caCertificate);
            KeyStore keyStore = trustStore;
            return keyStore;
        }
        finally {
            if (pemParser != null) {
                IOUtils.closeQuietly((Reader)pemParser);
            }
            if (reader != null) {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Certificate loadCertificate(String dockerCertPath) throws IOException, CertificateException {
        File certificate = new File(dockerCertPath, "cert.pem");
        BufferedReader reader = new BufferedReader(new FileReader(certificate));
        PEMParser pemParser = null;
        try {
            pemParser = new PEMParser((Reader)reader);
            X509CertificateHolder certificateHolder = (X509CertificateHolder)pemParser.readObject();
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
            return x509Certificate;
        }
        finally {
            if (pemParser != null) {
                IOUtils.closeQuietly((Reader)pemParser);
            }
            if (reader != null) {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyPair loadPrivateKey(String dockerCertPath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        File certificate = new File(dockerCertPath, "key.pem");
        BufferedReader reader = new BufferedReader(new FileReader(certificate));
        PEMParser pemParser = null;
        try {
            pemParser = new PEMParser((Reader)reader);
            PEMKeyPair pemKeyPair = (PEMKeyPair)pemParser.readObject();
            byte[] pemPrivateKeyEncoded = pemKeyPair.getPrivateKeyInfo().getEncoded();
            byte[] pemPublicKeyEncoded = pemKeyPair.getPublicKeyInfo().getEncoded();
            KeyFactory factory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(pemPublicKeyEncoded);
            PublicKey publicKey = factory.generatePublic(publicKeySpec);
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pemPrivateKeyEncoded);
            PrivateKey privateKey = factory.generatePrivate(privateKeySpec);
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            return keyPair;
        }
        finally {
            if (pemParser != null) {
                IOUtils.closeQuietly((Reader)pemParser);
            }
            if (reader != null) {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
    }
}

