/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.core.FilePathUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;

public class CompressArchiveUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File archiveTARFiles(File base, Iterable<File> files, String archiveNameWithOutExtension) throws IOException {
        File tarFile = new File(FileUtils.getTempDirectoryPath(), archiveNameWithOutExtension + ".tar");
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(tarFile));){
            tos.setLongFileMode(2);
            for (File file : files) {
                TarArchiveEntry tarEntry = new TarArchiveEntry(file);
                tarEntry.setName(FilePathUtil.relativize(base, file));
                if (!file.isDirectory() && file.canExecute()) {
                    tarEntry.setMode(tarEntry.getMode() | 0x1ED);
                }
                tos.putArchiveEntry((ArchiveEntry)tarEntry);
                if (!file.isDirectory()) {
                    FileUtils.copyFile((File)file, (OutputStream)tos);
                }
                tos.closeArchiveEntry();
            }
        }
        return tarFile;
    }
}

