/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.FilePathUtil;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.github.dockerjava.core.dockerfile.Dockerfile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import shaded.com.google.common.base.Preconditions;

public class BuildImageCmdImpl
extends AbstrDockerCmd<BuildImageCmd, BuildImageCmd.Response>
implements BuildImageCmd {
    private InputStream tarInputStream = null;
    private String tag;
    private boolean noCache;
    private boolean remove = true;
    private boolean quiet;
    private boolean pull;
    private AuthConfigurations buildAuthConfigs;
    private File dockerFile;
    private File baseDirectory;

    public BuildImageCmdImpl(BuildImageCmd.Exec exec) {
        super(exec);
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec, File dockerFileOrFolder) {
        super(exec);
        Preconditions.checkNotNull(dockerFileOrFolder, "dockerFolder is null");
        if (dockerFileOrFolder.isDirectory()) {
            this.withBaseDirectory(dockerFileOrFolder);
            this.withDockerfile(new File(dockerFileOrFolder, "Dockerfile"));
        } else {
            this.withDockerfile(dockerFileOrFolder);
        }
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec, InputStream tarInputStream) {
        super(exec);
        Preconditions.checkNotNull(tarInputStream, "tarInputStream is null");
        this.withTarInputStream(tarInputStream);
    }

    @Override
    public InputStream getTarInputStream() {
        return this.tarInputStream;
    }

    @Override
    public BuildImageCmdImpl withDockerfile(File dockerfile) {
        Preconditions.checkNotNull(dockerfile);
        if (!dockerfile.exists()) {
            throw new IllegalArgumentException("Dockerfile does not exist");
        }
        if (!dockerfile.isFile()) {
            throw new IllegalArgumentException("Not a directory");
        }
        if (this.baseDirectory == null) {
            this.withBaseDirectory(dockerfile.getParentFile());
        }
        this.dockerFile = dockerfile;
        try {
            this.withTarInputStream(new Dockerfile(dockerfile).parse().buildDockerFolderTar(this.baseDirectory));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public BuildImageCmdImpl withTarInputStream(InputStream tarInputStream) {
        Preconditions.checkNotNull(tarInputStream, "tarInputStream is null");
        this.tarInputStream = tarInputStream;
        return this;
    }

    @Override
    public BuildImageCmdImpl withTag(String tag) {
        Preconditions.checkNotNull(tag, "Tag is null");
        this.tag = tag;
        return this;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean hasNoCacheEnabled() {
        return this.noCache;
    }

    @Override
    public boolean hasRemoveEnabled() {
        return this.remove;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public boolean hasPullEnabled() {
        return this.pull;
    }

    @Override
    public String getPathToDockerfile() {
        if (this.baseDirectory != null && this.dockerFile != null) {
            return FilePathUtil.relativize(this.baseDirectory, this.dockerFile);
        }
        return null;
    }

    @Override
    public AuthConfigurations getBuildAuthConfigs() {
        return this.buildAuthConfigs;
    }

    @Override
    public BuildImageCmd withBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        return this;
    }

    @Override
    public BuildImageCmdImpl withNoCache() {
        return this.withNoCache(true);
    }

    @Override
    public BuildImageCmdImpl withNoCache(boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    @Override
    public BuildImageCmdImpl withRemove() {
        return this.withRemove(true);
    }

    @Override
    public BuildImageCmdImpl withRemove(boolean rm) {
        this.remove = rm;
        return this;
    }

    @Override
    public BuildImageCmdImpl withQuiet() {
        return this.withQuiet(true);
    }

    @Override
    public BuildImageCmdImpl withQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    @Override
    public BuildImageCmdImpl withPull() {
        return this.withPull(true);
    }

    @Override
    public BuildImageCmdImpl withPull(boolean pull) {
        this.pull = pull;
        return this;
    }

    @Override
    public BuildImageCmd withBuildAuthConfigs(AuthConfigurations authConfigs) {
        Preconditions.checkNotNull(authConfigs, "authConfig is null");
        this.buildAuthConfigs = authConfigs;
        return this;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.tarInputStream.close();
    }

    public String toString() {
        return "build " + (this.tag != null ? "-t " + this.tag + " " : "") + (this.noCache ? "--nocache=true " : "") + (this.quiet ? "--quiet=true " : "") + (!this.remove ? "--rm=false " : "");
    }
}

