/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.model.ExposedPorts;
import com.github.dockerjava.api.model.Volumes;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import org.apache.commons.lang.builder.ToStringBuilder;
import shaded.com.google.common.base.Preconditions;

public class CommitCmdImpl
extends AbstrDockerCmd<CommitCmd, String>
implements CommitCmd {
    private String containerId;
    private String repository;
    private String tag;
    private String message;
    private String author;
    private boolean pause = true;
    @JsonProperty(value="AttachStdin")
    private boolean attachStdin;
    @JsonProperty(value="AttachStdout")
    private boolean attachStdout;
    @JsonProperty(value="AttachStderr")
    private boolean attachStderr;
    @JsonProperty(value="Cmd")
    private String[] cmd;
    @JsonProperty(value="DisableNetwork")
    private boolean disableNetwork;
    @JsonProperty(value="Env")
    private String[] env;
    @JsonProperty(value="ExposedPorts")
    private ExposedPorts exposedPorts;
    @JsonProperty(value="Hostname")
    private String hostname;
    @JsonProperty(value="Memory")
    private Integer memory;
    @JsonProperty(value="MemorySwap")
    private Integer memorySwap;
    @JsonProperty(value="OpenStdin")
    private boolean openStdin;
    @JsonProperty(value="PortSpecs")
    private String[] portSpecs;
    @JsonProperty(value="StdinOnce")
    private boolean stdinOnce;
    @JsonProperty(value="Tty")
    private boolean tty;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="Volumes")
    private Volumes volumes;
    @JsonProperty(value="WorkingDir")
    private String workingDir;

    public CommitCmdImpl(CommitCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public CommitCmdImpl withContainerId(String containerId) {
        Preconditions.checkNotNull(containerId, "containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public boolean hasPauseEnabled() {
        return this.pause;
    }

    @Override
    public CommitCmdImpl withAttachStderr(boolean attachStderr) {
        this.attachStderr = attachStderr;
        return this;
    }

    @Override
    public CommitCmdImpl withAttachStderr() {
        return this.withAttachStderr(true);
    }

    @Override
    public CommitCmdImpl withAttachStdin(boolean attachStdin) {
        this.attachStdin = attachStdin;
        return this;
    }

    @Override
    public CommitCmdImpl withAttachStdin() {
        return this.withAttachStdin(true);
    }

    @Override
    public CommitCmdImpl withAttachStdout(boolean attachStdout) {
        this.attachStdout = attachStdout;
        return this;
    }

    @Override
    public CommitCmdImpl withAttachStdout() {
        return this.withAttachStdout(true);
    }

    @Override
    public CommitCmdImpl withCmd(String ... cmd) {
        Preconditions.checkNotNull(cmd, "cmd was not specified");
        this.cmd = cmd;
        return this;
    }

    @Override
    public CommitCmdImpl withDisableNetwork(boolean disableNetwork) {
        this.disableNetwork = disableNetwork;
        return this;
    }

    @Override
    public CommitCmdImpl withAuthor(String author) {
        Preconditions.checkNotNull(author, "author was not specified");
        this.author = author;
        return this;
    }

    @Override
    public CommitCmdImpl withMessage(String message) {
        Preconditions.checkNotNull(message, "message was not specified");
        this.message = message;
        return this;
    }

    @Override
    public CommitCmdImpl withTag(String tag) {
        Preconditions.checkNotNull(tag, "tag was not specified");
        this.tag = tag;
        return this;
    }

    @Override
    public CommitCmdImpl withRepository(String repository) {
        Preconditions.checkNotNull(repository, "repository was not specified");
        this.repository = repository;
        return this;
    }

    @Override
    public CommitCmdImpl withPause(boolean pause) {
        this.pause = pause;
        return this;
    }

    @Override
    public String[] getEnv() {
        return this.env;
    }

    @Override
    public CommitCmdImpl withEnv(String ... env) {
        Preconditions.checkNotNull(env, "env was not specified");
        this.env = env;
        return this;
    }

    @Override
    public ExposedPorts getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public CommitCmdImpl withExposedPorts(ExposedPorts exposedPorts) {
        Preconditions.checkNotNull(exposedPorts, "exposedPorts was not specified");
        this.exposedPorts = exposedPorts;
        return this;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public CommitCmdImpl withHostname(String hostname) {
        Preconditions.checkNotNull(hostname, "hostname was not specified");
        this.hostname = hostname;
        return this;
    }

    @Override
    public Integer getMemory() {
        return this.memory;
    }

    @Override
    public CommitCmdImpl withMemory(Integer memory) {
        Preconditions.checkNotNull(memory, "memory was not specified");
        this.memory = memory;
        return this;
    }

    @Override
    public Integer getMemorySwap() {
        return this.memorySwap;
    }

    @Override
    public CommitCmdImpl withMemorySwap(Integer memorySwap) {
        Preconditions.checkNotNull(memorySwap, "memorySwap was not specified");
        this.memorySwap = memorySwap;
        return this;
    }

    @Override
    public boolean isOpenStdin() {
        return this.openStdin;
    }

    @Override
    public CommitCmdImpl withOpenStdin(boolean openStdin) {
        Preconditions.checkNotNull(openStdin, "openStdin was not specified");
        this.openStdin = openStdin;
        return this;
    }

    @Override
    public String[] getPortSpecs() {
        return this.portSpecs;
    }

    @Override
    public CommitCmdImpl withPortSpecs(String ... portSpecs) {
        Preconditions.checkNotNull(portSpecs, "portSpecs was not specified");
        this.portSpecs = portSpecs;
        return this;
    }

    @Override
    public boolean isStdinOnce() {
        return this.stdinOnce;
    }

    @Override
    public CommitCmdImpl withStdinOnce(boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return this;
    }

    @Override
    public CommitCmdImpl withStdinOnce() {
        return this.withStdinOnce(true);
    }

    @Override
    public boolean isTty() {
        return this.tty;
    }

    @Override
    public CommitCmdImpl withTty(boolean tty) {
        this.tty = tty;
        return this;
    }

    @Override
    public CommitCmdImpl withTty() {
        return this.withTty(true);
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public CommitCmdImpl withUser(String user) {
        Preconditions.checkNotNull(user, "user was not specified");
        this.user = user;
        return this;
    }

    @Override
    public Volumes getVolumes() {
        return this.volumes;
    }

    @Override
    public CommitCmdImpl withVolumes(Volumes volumes) {
        Preconditions.checkNotNull(volumes, "volumes was not specified");
        this.volumes = volumes;
        return this;
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public CommitCmdImpl withWorkingDir(String workingDir) {
        Preconditions.checkNotNull(workingDir, "workingDir was not specified");
        this.workingDir = workingDir;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)"commit ").append((Object)(this.author != null ? "--author " + this.author + " " : "")).append((Object)(this.message != null ? "--message " + this.message + " " : "")).append((Object)this.containerId).append((Object)(this.repository != null ? " " + this.repository + ":" : " ")).append((Object)(this.tag != null ? this.tag : "")).toString();
    }

    @Override
    public String exec() throws NotFoundException {
        return (String)super.exec();
    }
}

