/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;

public class EventStreamReader<I>
implements AutoCloseable {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Class<I> type;
    private final InputStream inputStream;

    public EventStreamReader(InputStream inputStream, Class<I> type) {
        this.inputStream = inputStream;
        this.type = type;
    }

    public I readItem() throws IOException {
        try {
            return (I)this.objectMapper.readValue(this.inputStream, this.type);
        }
        catch (IOException e) {
            if (e.getMessage().equals("Stream closed")) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

