/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import java.io.IOException;
import java.io.InputStream;

public class FrameReader
implements AutoCloseable {
    private static final int HEADER_SIZE = 8;
    private final InputStream inputStream;

    public FrameReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    private static StreamType streamType(byte streamType) {
        switch (streamType) {
            case 0: {
                return StreamType.STDIN;
            }
            case 1: {
                return StreamType.STDOUT;
            }
            case 2: {
                return StreamType.STDERR;
            }
        }
        throw new IllegalArgumentException("invalid streamType");
    }

    public Frame readFrame() throws IOException {
        byte[] header = new byte[8];
        int headerSize = this.inputStream.read(header);
        if (headerSize == -1) {
            return null;
        }
        if (headerSize != 8) {
            throw new IOException(String.format("header must be %d bytes long, but was %d", 8, headerSize));
        }
        int payloadSize = ((header[4] & 0xFF) << 24) + ((header[5] & 0xFF) << 16) + ((header[6] & 0xFF) << 8) + (header[7] & 0xFF);
        byte[] payload = new byte[payloadSize];
        int actualPayloadSize = this.inputStream.read(payload);
        if (actualPayloadSize != payloadSize) {
            throw new IOException(String.format("payload must be %d bytes long, but was %d", payloadSize, actualPayloadSize));
        }
        return new Frame(FrameReader.streamType(header[0]), payload);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

