/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.command.AbstrAuthCfgDockerCmd;
import java.io.InputStream;
import shaded.com.google.common.base.Preconditions;

public class PullImageCmdImpl
extends AbstrAuthCfgDockerCmd<PullImageCmd, InputStream>
implements PullImageCmd {
    private String repository;
    private String tag;
    private String registry;

    public PullImageCmdImpl(PullImageCmd.Exec exec, AuthConfig authConfig, String repository) {
        super(exec, authConfig);
        this.withRepository(repository);
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String getRegistry() {
        return this.registry;
    }

    @Override
    public PullImageCmd withRepository(String repository) {
        Preconditions.checkNotNull(repository, "repository was not specified");
        this.repository = repository;
        return this;
    }

    @Override
    public PullImageCmd withTag(String tag) {
        Preconditions.checkNotNull(tag, "tag was not specified");
        this.tag = tag;
        return this;
    }

    @Override
    public PullImageCmd withRegistry(String registry) {
        Preconditions.checkNotNull(registry, "registry was not specified");
        this.registry = registry;
        return this;
    }

    public String toString() {
        return "pull " + this.repository + (this.tag != null ? ":" + this.tag : "");
    }
}

