/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import shaded.com.google.common.base.Preconditions;

public class RemoveImageCmdImpl
extends AbstrDockerCmd<RemoveImageCmd, Void>
implements RemoveImageCmd {
    private String imageId;
    private boolean force;
    private boolean noPrune;

    public RemoveImageCmdImpl(RemoveImageCmd.Exec exec, String imageId) {
        super(exec);
        this.withImageId(imageId);
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public boolean hasForceEnabled() {
        return this.force;
    }

    @Override
    public boolean hasNoPruneEnabled() {
        return this.noPrune;
    }

    @Override
    public RemoveImageCmd withImageId(String imageId) {
        Preconditions.checkNotNull(imageId, "imageId was not specified");
        this.imageId = imageId;
        return this;
    }

    @Override
    public RemoveImageCmd withForce() {
        return this.withForce(true);
    }

    @Override
    public RemoveImageCmd withForce(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public RemoveImageCmd withNoPrune() {
        return this.withNoPrune(true);
    }

    @Override
    public RemoveImageCmd withNoPrune(boolean noPrune) {
        this.noPrune = noPrune;
        return this;
    }

    public String toString() {
        return "rmi " + (this.noPrune ? "--no-prune=true" : "") + (this.force ? "--force=true" : "") + this.imageId;
    }

    @Override
    public Void exec() throws NotFoundException {
        return (Void)super.exec();
    }
}

