/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.NotModifiedException;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Binds;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Links;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import org.apache.commons.lang.builder.ToStringBuilder;
import shaded.com.google.common.base.Preconditions;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class StartContainerCmdImpl
extends AbstrDockerCmd<StartContainerCmd, Void>
implements StartContainerCmd {
    @JsonIgnore
    private String containerId;
    @JsonProperty(value="Binds")
    private Binds binds;
    @JsonProperty(value="Links")
    private Links links;
    @JsonProperty(value="LxcConf")
    private LxcConf[] lxcConf;
    @JsonProperty(value="PortBindings")
    private Ports portBindings;
    @JsonProperty(value="PublishAllPorts")
    private Boolean publishAllPorts;
    @JsonProperty(value="Privileged")
    private Boolean privileged;
    @JsonProperty(value="Dns")
    private String[] dns;
    @JsonProperty(value="DnsSearch")
    private String[] dnsSearch;
    @JsonProperty(value="VolumesFrom")
    private String volumesFrom;
    @JsonProperty(value="NetworkMode")
    private String networkMode;
    @JsonProperty(value="Devices")
    private Device[] devices;
    @JsonProperty(value="ExtraHosts")
    private String[] extraHosts;
    @JsonProperty(value="RestartPolicy")
    private RestartPolicy restartPolicy;
    @JsonProperty(value="CapAdd")
    private Capability[] capAdd;
    @JsonProperty(value="CapDrop")
    private Capability[] capDrop;

    public StartContainerCmdImpl(StartContainerCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    @Override
    @JsonIgnore
    public Bind[] getBinds() {
        return this.binds == null ? new Bind[]{} : this.binds.getBinds();
    }

    @Override
    @JsonIgnore
    public Link[] getLinks() {
        return this.links == null ? new Link[]{} : this.links.getLinks();
    }

    @Override
    public LxcConf[] getLxcConf() {
        return this.lxcConf;
    }

    @Override
    public Ports getPortBindings() {
        return this.portBindings;
    }

    @Override
    public Boolean isPublishAllPorts() {
        return this.publishAllPorts;
    }

    @Override
    public Boolean isPrivileged() {
        return this.privileged;
    }

    @Override
    public String[] getDns() {
        return this.dns;
    }

    @Override
    public String[] getDnsSearch() {
        return this.dnsSearch;
    }

    @Override
    public String getVolumesFrom() {
        return this.volumesFrom;
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public String getNetworkMode() {
        return this.networkMode;
    }

    @Override
    public Device[] getDevices() {
        return this.devices;
    }

    @Override
    public String[] getExtraHosts() {
        return this.extraHosts;
    }

    @Override
    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public Capability[] getCapAdd() {
        return this.capAdd;
    }

    @Override
    public Capability[] getCapDrop() {
        return this.capDrop;
    }

    @Override
    @JsonIgnore
    public StartContainerCmd withBinds(Bind ... binds) {
        Preconditions.checkNotNull(binds, "binds was not specified");
        this.binds = new Binds(binds);
        return this;
    }

    @Override
    @JsonIgnore
    public StartContainerCmd withLinks(Link ... links) {
        Preconditions.checkNotNull(links, "links was not specified");
        this.links = new Links(links);
        return this;
    }

    @Override
    public StartContainerCmd withLxcConf(LxcConf ... lxcConf) {
        Preconditions.checkNotNull(lxcConf, "lxcConf was not specified");
        this.lxcConf = lxcConf;
        return this;
    }

    @Override
    public StartContainerCmd withPortBindings(Ports portBindings) {
        Preconditions.checkNotNull(portBindings, "portBindings was not specified");
        this.portBindings = portBindings;
        return this;
    }

    @Override
    public StartContainerCmd withPortBindings(PortBinding ... portBindings) {
        Preconditions.checkNotNull(portBindings, "portBindings was not specified");
        if (this.portBindings == null) {
            this.portBindings = new Ports();
        }
        this.portBindings.add(portBindings);
        return this;
    }

    @Override
    public StartContainerCmd withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @Override
    public StartContainerCmd withPublishAllPorts(Boolean publishAllPorts) {
        this.publishAllPorts = publishAllPorts;
        return this;
    }

    @Override
    public StartContainerCmd withDns(String ... dns) {
        Preconditions.checkNotNull(dns, "dns was not specified");
        this.dns = dns;
        return this;
    }

    @Override
    public StartContainerCmd withDnsSearch(String ... dnsSearch) {
        Preconditions.checkNotNull(dnsSearch, "dnsSearch was not specified");
        this.dnsSearch = dnsSearch;
        return this;
    }

    @Override
    public StartContainerCmd withVolumesFrom(String volumesFrom) {
        Preconditions.checkNotNull(volumesFrom, "volumesFrom was not specified");
        this.volumesFrom = volumesFrom;
        return this;
    }

    @Override
    public StartContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull(containerId, "containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    public StartContainerCmd withNetworkMode(String networkMode) {
        Preconditions.checkNotNull(networkMode, "networkMode was not specified");
        this.networkMode = networkMode;
        return this;
    }

    @Override
    public StartContainerCmd withDevices(Device ... devices) {
        Preconditions.checkNotNull(devices, "devices was not specified");
        this.devices = devices;
        return this;
    }

    @Override
    public StartContainerCmd withExtraHosts(String ... extraHosts) {
        Preconditions.checkNotNull(extraHosts, "extraHosts was not specified");
        this.extraHosts = extraHosts;
        return this;
    }

    @Override
    public StartContainerCmd withRestartPolicy(RestartPolicy restartPolicy) {
        Preconditions.checkNotNull(restartPolicy, "restartPolicy was not specified");
        this.restartPolicy = restartPolicy;
        return this;
    }

    @Override
    public StartContainerCmd withCapAdd(Capability ... capAdd) {
        Preconditions.checkNotNull(capAdd, "capAdd was not specified");
        this.capAdd = capAdd;
        return this;
    }

    @Override
    public StartContainerCmd withCapDrop(Capability ... capDrop) {
        Preconditions.checkNotNull(capDrop, "capDrop was not specified");
        this.capDrop = capDrop;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this).toString();
    }

    @Override
    public Void exec() throws NotFoundException, NotModifiedException {
        return (Void)super.exec();
    }
}

