/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.dockerfile;

import com.github.dockerjava.api.DockerClientException;
import com.github.dockerjava.core.CompressArchiveUtil;
import com.github.dockerjava.core.FilePathUtil;
import com.github.dockerjava.core.GoLangFileMatch;
import com.github.dockerjava.core.GoLangFileMatchException;
import com.github.dockerjava.core.GoLangMatchFileFilter;
import com.github.dockerjava.core.dockerfile.DockerfileStatement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import shaded.com.google.common.base.Function;
import shaded.com.google.common.base.Objects;
import shaded.com.google.common.base.Optional;
import shaded.com.google.common.collect.Collections2;

public class Dockerfile {
    public final File dockerFile;

    public Dockerfile(File dockerFile) {
        if (!dockerFile.exists()) {
            throw new IllegalStateException(String.format("Dockerfile %s does not exist", dockerFile.getAbsolutePath()));
        }
        if (!dockerFile.isFile()) {
            throw new IllegalStateException(String.format("Dockerfile %s is not a file", dockerFile.getAbsolutePath()));
        }
        this.dockerFile = dockerFile;
    }

    public Iterable<DockerfileStatement> getStatements() throws IOException {
        List dockerFileContent = FileUtils.readLines((File)this.dockerFile);
        if (dockerFileContent.size() <= 0) {
            throw new DockerClientException(String.format("Dockerfile %s is empty", this.dockerFile));
        }
        Collection<Optional<? extends DockerfileStatement>> optionals = Collections2.transform(dockerFileContent, new LineTransformer());
        return Optional.presentInstances(optionals);
    }

    public List<String> getIgnores() throws IOException {
        ArrayList<String> ignores = new ArrayList<String>();
        File dockerIgnoreFile = new File(this.getDockerFolder(), ".dockerignore");
        if (dockerIgnoreFile.exists()) {
            int lineNumber = 0;
            List dockerIgnoreFileContent = FileUtils.readLines((File)dockerIgnoreFile);
            for (String pattern : dockerIgnoreFileContent) {
                ++lineNumber;
                if ((pattern = pattern.trim()).isEmpty()) continue;
                pattern = FilenameUtils.normalize((String)pattern);
                try {
                    if (GoLangFileMatch.match(pattern, "Dockerfile")) {
                        throw new DockerClientException(String.format("Dockerfile is excluded by pattern '%s' on line %s in .dockerignore file", pattern, lineNumber));
                    }
                    ignores.add(pattern);
                }
                catch (GoLangFileMatchException e) {
                    throw new DockerClientException(String.format("Invalid pattern '%s' on line %s in .dockerignore file", pattern, lineNumber));
                }
            }
        }
        return ignores;
    }

    public ScannedResult parse() throws IOException {
        return new ScannedResult();
    }

    public File getDockerFolder() {
        return this.dockerFile.getParentFile();
    }

    public class ScannedResult {
        final List<String> ignores;
        final Map<String, String> environmentMap = new HashMap<String, String>();
        final List<File> filesToAdd = new ArrayList<File>();

        public InputStream buildDockerFolderTar() {
            return this.buildDockerFolderTar(Dockerfile.this.getDockerFolder());
        }

        public InputStream buildDockerFolderTar(File directory) {
            File dockerFolderTar = null;
            try {
                String archiveNameWithOutExtension = UUID.randomUUID().toString();
                dockerFolderTar = CompressArchiveUtil.archiveTARFiles(directory, this.filesToAdd, archiveNameWithOutExtension);
                return FileUtils.openInputStream((File)dockerFolderTar);
            }
            catch (IOException ex) {
                FileUtils.deleteQuietly(dockerFolderTar);
                throw new DockerClientException("Error occurred while preparing Docker context folder.", ex);
            }
        }

        public String toString() {
            return Objects.toStringHelper(this).add("ignores", this.ignores).add("environmentMap", this.environmentMap).add("filesToAdd", this.filesToAdd).toString();
        }

        public ScannedResult() throws IOException {
            this.ignores = Dockerfile.this.getIgnores();
            this.filesToAdd.add(Dockerfile.this.dockerFile);
            for (DockerfileStatement statement : Dockerfile.this.getStatements()) {
                if (statement instanceof DockerfileStatement.Env) {
                    this.processEnvStatement((DockerfileStatement.Env)statement);
                    continue;
                }
                if (!(statement instanceof DockerfileStatement.Add)) continue;
                this.processAddStatement((DockerfileStatement.Add)statement);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processAddStatement(DockerfileStatement.Add add) throws IOException {
            if (!((DockerfileStatement.Add)(add = ((DockerfileStatement.Add)add).transform((Map)this.environmentMap))).isFileResource()) return;
            File dockerFolder = Dockerfile.this.getDockerFolder();
            String resource = ((DockerfileStatement.Add)add).source;
            File src = new File(resource);
            if (src.isAbsolute()) {
                throw new DockerClientException(String.format("Source file %s must be relative to %s", src, dockerFolder));
            }
            src = new File(dockerFolder, resource);
            if (src.exists()) {
                if ((src = src.getCanonicalFile()).isDirectory()) {
                    Collection files = FileUtils.listFiles((File)src, (IOFileFilter)new GoLangMatchFileFilter(src, this.ignores), (IOFileFilter)TrueFileFilter.INSTANCE);
                    this.filesToAdd.addAll(files);
                    return;
                } else {
                    if (GoLangFileMatch.match(this.ignores, FilePathUtil.relativize(dockerFolder, src))) throw new DockerClientException(String.format("Source file %s is excluded by .dockerignore file", src));
                    this.filesToAdd.add(src);
                }
                return;
            } else {
                this.filesToAdd.addAll(this.resolveWildcards(src, this.ignores));
            }
        }

        private Collection<File> resolveWildcards(File file, List<String> ignores) {
            ArrayList<File> filesToAdd = new ArrayList<File>();
            File parent = file.getParentFile();
            if (parent != null) {
                if (parent.isDirectory()) {
                    Collection files = FileUtils.listFiles((File)parent, (IOFileFilter)new GoLangMatchFileFilter(parent, ignores), (IOFileFilter)TrueFileFilter.INSTANCE);
                    filesToAdd.addAll(files);
                } else {
                    filesToAdd.addAll(this.resolveWildcards(parent, ignores));
                }
            } else {
                throw new DockerClientException(String.format("Source file %s doesn't exist", file));
            }
            return filesToAdd;
        }

        private void processEnvStatement(DockerfileStatement.Env env) {
            this.environmentMap.put(env.variable, env.value);
        }
    }

    private static class LineTransformer
    implements Function<String, Optional<? extends DockerfileStatement>> {
        private int line = 0;

        private LineTransformer() {
        }

        @Override
        public Optional<? extends DockerfileStatement> apply(String input) {
            try {
                ++this.line;
                return DockerfileStatement.createFromLine(input);
            }
            catch (Exception ex) {
                throw new DockerClientException("Error on dockerfile line " + this.line);
            }
        }
    }
}

