/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.EventStreamItem;
import com.github.dockerjava.jaxrs.AbstrDockerCmdExec;
import com.github.dockerjava.jaxrs.util.WrappedResponseInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.collect.ImmutableList;

public class BuildImageCmdExec
extends AbstrDockerCmdExec<BuildImageCmd, BuildImageCmd.Response>
implements BuildImageCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildImageCmdExec.class);

    public BuildImageCmdExec(WebTarget baseResource) {
        super(baseResource);
    }

    @Override
    protected ResponseImpl execute(BuildImageCmd command) {
        WebTarget webResource = this.getBaseResource().path("/build");
        String dockerFilePath = command.getPathToDockerfile();
        if (command.getTag() != null) {
            webResource = webResource.queryParam("t", new Object[]{command.getTag()});
        }
        if (command.hasNoCacheEnabled()) {
            webResource = webResource.queryParam("nocache", new Object[]{"true"});
        }
        if (!command.hasRemoveEnabled()) {
            webResource = webResource.queryParam("rm", new Object[]{"false"});
        }
        if (command.isQuiet()) {
            webResource = webResource.queryParam("q", new Object[]{"true"});
        }
        if (command.hasPullEnabled()) {
            webResource = webResource.queryParam("pull", new Object[]{"true"});
        }
        if (dockerFilePath != null && !"Dockerfile".equals(dockerFilePath)) {
            webResource = webResource.queryParam("dockerfile", new Object[]{dockerFilePath});
        }
        webResource.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        webResource.property("jersey.config.client.chunkedEncodingSize", (Object)0x100000);
        LOGGER.debug("POST: {}", (Object)webResource);
        Response response = (Response)this.resourceWithOptionalAuthConfig(command, webResource.request()).accept(new String[]{"text/plain"}).post(Entity.entity((Object)command.getTarInputStream(), (String)"application/tar"), Response.class);
        return new ResponseImpl(new WrappedResponseInputStream(response));
    }

    private Invocation.Builder resourceWithOptionalAuthConfig(BuildImageCmd command, Invocation.Builder request) {
        AuthConfigurations authConfigs = command.getBuildAuthConfigs();
        if (authConfigs != null) {
            request = request.header("X-Registry-Config", (Object)this.registryConfigs(authConfigs));
        }
        return request;
    }

    public static class ResponseImpl
    extends BuildImageCmd.Response {
        private final InputStream proxy;

        public ResponseImpl(InputStream proxy) {
            this.proxy = proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterable<EventStreamItem> getItems() throws IOException {
            ObjectMapper mapper = new ObjectMapper();
            ObjectReader reader = mapper.reader(EventStreamItem.class);
            MappingIterator items = reader.readValues(this.proxy);
            try {
                ImmutableList<EventStreamItem> immutableList = ImmutableList.copyOf(items);
                return immutableList;
            }
            finally {
                this.proxy.close();
            }
        }

        @Override
        public int read() throws IOException {
            return this.proxy.read();
        }

        @Override
        public void close() throws IOException {
            this.proxy.close();
            super.close();
        }
    }
}

