/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.github.dockerjava.api.DockerClientException;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectExecCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.util.FollowRedirectsFilter;
import com.github.dockerjava.core.util.JsonClientFilter;
import com.github.dockerjava.core.util.ResponseStatusExceptionFilter;
import com.github.dockerjava.core.util.SelectiveLoggingFilter;
import com.github.dockerjava.jaxrs.AttachContainerCmdExec;
import com.github.dockerjava.jaxrs.AuthCmdExec;
import com.github.dockerjava.jaxrs.BuildImageCmdExec;
import com.github.dockerjava.jaxrs.CommitCmdExec;
import com.github.dockerjava.jaxrs.ContainerDiffCmdExec;
import com.github.dockerjava.jaxrs.CopyFileFromContainerCmdExec;
import com.github.dockerjava.jaxrs.CreateContainerCmdExec;
import com.github.dockerjava.jaxrs.CreateImageCmdExec;
import com.github.dockerjava.jaxrs.EventsCmdExec;
import com.github.dockerjava.jaxrs.ExecCreateCmdExec;
import com.github.dockerjava.jaxrs.ExecStartCmdExec;
import com.github.dockerjava.jaxrs.InfoCmdExec;
import com.github.dockerjava.jaxrs.InspectContainerCmdExec;
import com.github.dockerjava.jaxrs.InspectExecCmdExec;
import com.github.dockerjava.jaxrs.InspectImageCmdExec;
import com.github.dockerjava.jaxrs.KillContainerCmdExec;
import com.github.dockerjava.jaxrs.ListContainersCmdExec;
import com.github.dockerjava.jaxrs.ListImagesCmdExec;
import com.github.dockerjava.jaxrs.LogContainerCmdExec;
import com.github.dockerjava.jaxrs.PauseContainerCmdExec;
import com.github.dockerjava.jaxrs.PingCmdExec;
import com.github.dockerjava.jaxrs.PullImageCmdExec;
import com.github.dockerjava.jaxrs.PushImageCmdExec;
import com.github.dockerjava.jaxrs.RemoveContainerCmdExec;
import com.github.dockerjava.jaxrs.RemoveImageCmdExec;
import com.github.dockerjava.jaxrs.RestartContainerCmdExec;
import com.github.dockerjava.jaxrs.SaveImageCmdExec;
import com.github.dockerjava.jaxrs.SearchImagesCmdExec;
import com.github.dockerjava.jaxrs.StartContainerCmdExec;
import com.github.dockerjava.jaxrs.StopContainerCmdExec;
import com.github.dockerjava.jaxrs.TagImageCmdExec;
import com.github.dockerjava.jaxrs.TopContainerCmdExec;
import com.github.dockerjava.jaxrs.UnixConnectionSocketFactory;
import com.github.dockerjava.jaxrs.UnpauseContainerCmdExec;
import com.github.dockerjava.jaxrs.VersionCmdExec;
import com.github.dockerjava.jaxrs.WaitContainerCmdExec;
import java.io.IOException;
import java.net.URI;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.base.Preconditions;
import shaded.org.apache.http.config.Registry;
import shaded.org.apache.http.config.RegistryBuilder;
import shaded.org.apache.http.conn.socket.ConnectionSocketFactory;
import shaded.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class DockerCmdExecFactoryImpl
implements DockerCmdExecFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DockerCmdExecFactoryImpl.class.getName());
    private Client client;
    private WebTarget baseResource;

    @Override
    public void init(DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(dockerClientConfig, "config was not specified");
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.connectorProvider(new ApacheConnectorProvider());
        clientConfig.property("jersey.config.disableAutoDiscovery", true);
        clientConfig.register((Class)ResponseStatusExceptionFilter.class);
        clientConfig.register((Class)JsonClientFilter.class);
        clientConfig.register((Class)JacksonJsonProvider.class);
        if (dockerClientConfig.followRedirectsFilterEnabled()) {
            clientConfig.register((Class)FollowRedirectsFilter.class);
        }
        if (dockerClientConfig.isLoggingFilterEnabled()) {
            clientConfig.register(new SelectiveLoggingFilter(LOGGER, true));
        }
        if (dockerClientConfig.getReadTimeout() != null) {
            int readTimeout = dockerClientConfig.getReadTimeout();
            clientConfig.property("jersey.config.client.readTimeout", readTimeout);
        }
        URI originalUri = dockerClientConfig.getUri();
        SSLContext sslContext = null;
        if (dockerClientConfig.getSslConfig() != null) {
            try {
                sslContext = dockerClientConfig.getSslConfig().getSSLContext();
            }
            catch (Exception ex) {
                throw new DockerClientException("Error in SSL Configuration", ex);
            }
        }
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(this.getSchemeRegistry(originalUri, sslContext));
        if (dockerClientConfig.getMaxTotalConnections() != null) {
            connManager.setMaxTotal(dockerClientConfig.getMaxTotalConnections());
        }
        if (dockerClientConfig.getMaxPerRoutConnections() != null) {
            connManager.setDefaultMaxPerRoute(dockerClientConfig.getMaxPerRoutConnections());
        }
        clientConfig.property("jersey.config.apache.client.connectionManager", connManager);
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)clientConfig);
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        this.client = clientBuilder.build();
        if (originalUri.getScheme().equals("unix")) {
            dockerClientConfig.setUri(UnixConnectionSocketFactory.sanitizeUri(originalUri));
        }
        WebTarget webResource = this.client.target(dockerClientConfig.getUri());
        this.baseResource = dockerClientConfig.getVersion() == null || dockerClientConfig.getVersion().isEmpty() ? webResource : webResource.path("v" + dockerClientConfig.getVersion());
    }

    private Registry<ConnectionSocketFactory> getSchemeRegistry(URI originalUri, SSLContext sslContext) {
        RegistryBuilder<ConnectionSocketFactory> registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", PlainConnectionSocketFactory.getSocketFactory());
        if (sslContext != null) {
            registryBuilder.register("https", new SSLConnectionSocketFactory(sslContext));
        }
        registryBuilder.register("unix", new UnixConnectionSocketFactory(originalUri));
        return registryBuilder.build();
    }

    protected WebTarget getBaseResource() {
        Preconditions.checkNotNull(this.baseResource, "Factory not initialized. You probably forgot to call init()!");
        return this.baseResource;
    }

    @Override
    public AuthCmd.Exec createAuthCmdExec() {
        return new AuthCmdExec(this.getBaseResource());
    }

    @Override
    public InfoCmd.Exec createInfoCmdExec() {
        return new InfoCmdExec(this.getBaseResource());
    }

    @Override
    public PingCmd.Exec createPingCmdExec() {
        return new PingCmdExec(this.getBaseResource());
    }

    @Override
    public VersionCmd.Exec createVersionCmdExec() {
        return new VersionCmdExec(this.getBaseResource());
    }

    @Override
    public PullImageCmd.Exec createPullImageCmdExec() {
        return new PullImageCmdExec(this.getBaseResource());
    }

    @Override
    public PushImageCmd.Exec createPushImageCmdExec() {
        return new PushImageCmdExec(this.getBaseResource());
    }

    @Override
    public SaveImageCmd.Exec createSaveImageCmdExec() {
        return new SaveImageCmdExec(this.getBaseResource());
    }

    @Override
    public CreateImageCmd.Exec createCreateImageCmdExec() {
        return new CreateImageCmdExec(this.getBaseResource());
    }

    @Override
    public SearchImagesCmd.Exec createSearchImagesCmdExec() {
        return new SearchImagesCmdExec(this.getBaseResource());
    }

    @Override
    public RemoveImageCmd.Exec createRemoveImageCmdExec() {
        return new RemoveImageCmdExec(this.getBaseResource());
    }

    @Override
    public ListImagesCmd.Exec createListImagesCmdExec() {
        return new ListImagesCmdExec(this.getBaseResource());
    }

    @Override
    public InspectImageCmd.Exec createInspectImageCmdExec() {
        return new InspectImageCmdExec(this.getBaseResource());
    }

    @Override
    public ListContainersCmd.Exec createListContainersCmdExec() {
        return new ListContainersCmdExec(this.getBaseResource());
    }

    @Override
    public CreateContainerCmd.Exec createCreateContainerCmdExec() {
        return new CreateContainerCmdExec(this.getBaseResource());
    }

    @Override
    public StartContainerCmd.Exec createStartContainerCmdExec() {
        return new StartContainerCmdExec(this.getBaseResource());
    }

    @Override
    public InspectContainerCmd.Exec createInspectContainerCmdExec() {
        return new InspectContainerCmdExec(this.getBaseResource());
    }

    @Override
    public ExecCreateCmd.Exec createExecCmdExec() {
        return new ExecCreateCmdExec(this.getBaseResource());
    }

    @Override
    public RemoveContainerCmd.Exec createRemoveContainerCmdExec() {
        return new RemoveContainerCmdExec(this.getBaseResource());
    }

    @Override
    public WaitContainerCmd.Exec createWaitContainerCmdExec() {
        return new WaitContainerCmdExec(this.getBaseResource());
    }

    @Override
    public AttachContainerCmd.Exec createAttachContainerCmdExec() {
        return new AttachContainerCmdExec(this.getBaseResource());
    }

    @Override
    public ExecStartCmd.Exec createExecStartCmdExec() {
        return new ExecStartCmdExec(this.getBaseResource());
    }

    @Override
    public InspectExecCmd.Exec createInspectExecCmdExec() {
        return new InspectExecCmdExec(this.getBaseResource());
    }

    @Override
    public LogContainerCmd.Exec createLogContainerCmdExec() {
        return new LogContainerCmdExec(this.getBaseResource());
    }

    @Override
    public CopyFileFromContainerCmd.Exec createCopyFileFromContainerCmdExec() {
        return new CopyFileFromContainerCmdExec(this.getBaseResource());
    }

    @Override
    public StopContainerCmd.Exec createStopContainerCmdExec() {
        return new StopContainerCmdExec(this.getBaseResource());
    }

    @Override
    public ContainerDiffCmd.Exec createContainerDiffCmdExec() {
        return new ContainerDiffCmdExec(this.getBaseResource());
    }

    @Override
    public KillContainerCmd.Exec createKillContainerCmdExec() {
        return new KillContainerCmdExec(this.getBaseResource());
    }

    @Override
    public RestartContainerCmd.Exec createRestartContainerCmdExec() {
        return new RestartContainerCmdExec(this.getBaseResource());
    }

    @Override
    public CommitCmd.Exec createCommitCmdExec() {
        return new CommitCmdExec(this.getBaseResource());
    }

    @Override
    public BuildImageCmd.Exec createBuildImageCmdExec() {
        return new BuildImageCmdExec(this.getBaseResource());
    }

    @Override
    public TopContainerCmd.Exec createTopContainerCmdExec() {
        return new TopContainerCmdExec(this.getBaseResource());
    }

    @Override
    public TagImageCmd.Exec createTagImageCmdExec() {
        return new TagImageCmdExec(this.getBaseResource());
    }

    @Override
    public PauseContainerCmd.Exec createPauseContainerCmdExec() {
        return new PauseContainerCmdExec(this.getBaseResource());
    }

    @Override
    public UnpauseContainerCmd.Exec createUnpauseContainerCmdExec() {
        return new UnpauseContainerCmdExec(this.baseResource);
    }

    @Override
    public EventsCmd.Exec createEventsCmdExec() {
        return new EventsCmdExec(this.getBaseResource());
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkNotNull(this.client, "Factory not initialized. You probably forgot to call init()!");
        this.client.close();
    }
}

