/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.jaxrs.AbstrDockerCmdExec;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.net.UrlEscapers;

public class ListImagesCmdExec
extends AbstrDockerCmdExec<ListImagesCmd, List<Image>>
implements ListImagesCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListImagesCmdExec.class);

    public ListImagesCmdExec(WebTarget baseResource) {
        super(baseResource);
    }

    @Override
    protected List<Image> execute(ListImagesCmd command) {
        WebTarget webResource = this.getBaseResource().path("/images/json").queryParam("all", new Object[]{command.hasShowAllEnabled() ? "1" : "0"});
        if (command.getFilters() != null) {
            webResource = webResource.queryParam("filters", new Object[]{UrlEscapers.urlPathSegmentEscaper().escape(command.getFilters())});
        }
        LOGGER.trace("GET: {}", (Object)webResource);
        List images = (List)webResource.request().accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Image>>(){});
        LOGGER.trace("Response: {}", (Object)images);
        return images;
    }
}

