/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.PushEventStreamItem;
import com.github.dockerjava.jaxrs.AbstrDockerCmdExec;
import com.github.dockerjava.jaxrs.util.WrappedResponseInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.collect.ImmutableList;

public class PushImageCmdExec
extends AbstrDockerCmdExec<PushImageCmd, PushImageCmd.Response>
implements PushImageCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushImageCmdExec.class);

    public PushImageCmdExec(WebTarget baseResource) {
        super(baseResource);
    }

    @Override
    protected ResponseImpl execute(PushImageCmd command) {
        WebTarget webResource = this.getBaseResource().path("/images/" + this.name(command) + "/push").queryParam("tag", new Object[]{command.getTag()});
        String registryAuth = this.registryAuth(command.getAuthConfig());
        LOGGER.trace("POST: {}", (Object)webResource);
        Response response = webResource.request().header("X-Registry-Auth", (Object)registryAuth).accept(new String[]{"application/json"}).post(Entity.entity(PushImageCmd.Response.class, (String)"application/json"));
        return new ResponseImpl(new WrappedResponseInputStream(response));
    }

    private String name(PushImageCmd command) {
        String name = command.getName();
        AuthConfig authConfig = command.getAuthConfig();
        return name.contains("/") ? name : authConfig.getUsername();
    }

    public static class ResponseImpl
    extends PushImageCmd.Response {
        private final InputStream proxy;

        ResponseImpl(InputStream proxy) {
            this.proxy = proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterable<PushEventStreamItem> getItems() throws IOException {
            ObjectMapper mapper = new ObjectMapper();
            ObjectReader reader = mapper.reader(PushEventStreamItem.class);
            MappingIterator items = reader.readValues(this.proxy);
            try {
                ImmutableList<PushEventStreamItem> immutableList = ImmutableList.copyOf(items);
                return immutableList;
            }
            finally {
                this.proxy.close();
            }
        }

        @Override
        public int read() throws IOException {
            return this.proxy.read();
        }
    }
}

