/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.http.impl.client;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import shaded.org.apache.http.annotation.ThreadSafe;
import shaded.org.apache.http.auth.AuthScope;
import shaded.org.apache.http.auth.Credentials;
import shaded.org.apache.http.auth.UsernamePasswordCredentials;
import shaded.org.apache.http.client.CredentialsProvider;
import shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import shaded.org.apache.http.util.Args;

@ThreadSafe
public class SystemDefaultCredentialsProvider
implements CredentialsProvider {
    private static final Map<String, String> SCHEME_MAP = new ConcurrentHashMap<String, String>();
    private final BasicCredentialsProvider internal = new BasicCredentialsProvider();

    private static String translateScheme(String key) {
        if (key == null) {
            return null;
        }
        String s = SCHEME_MAP.get(key);
        return s != null ? s : key;
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.internal.setCredentials(authscope, credentials);
    }

    public Credentials getCredentials(AuthScope authscope) {
        PasswordAuthentication systemcreds;
        Args.notNull(authscope, "Auth scope");
        Credentials localcreds = this.internal.getCredentials(authscope);
        if (localcreds != null) {
            return localcreds;
        }
        if (authscope.getHost() != null && (systemcreds = Authenticator.requestPasswordAuthentication(authscope.getHost(), null, authscope.getPort(), "http", null, SystemDefaultCredentialsProvider.translateScheme(authscope.getScheme()))) != null) {
            return new UsernamePasswordCredentials(systemcreds.getUserName(), new String(systemcreds.getPassword()));
        }
        return null;
    }

    public void clear() {
        this.internal.clear();
    }

    static {
        SCHEME_MAP.put("Basic".toUpperCase(Locale.ENGLISH), "Basic");
        SCHEME_MAP.put("Digest".toUpperCase(Locale.ENGLISH), "Digest");
        SCHEME_MAP.put("NTLM".toUpperCase(Locale.ENGLISH), "NTLM");
        SCHEME_MAP.put("negotiate".toUpperCase(Locale.ENGLISH), "SPNEGO");
        SCHEME_MAP.put("Kerberos".toUpperCase(Locale.ENGLISH), "Kerberos");
    }
}

