/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.NameParser;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.client.ClientConfigBuilderForPlugin;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerLauncher;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.ws.rs.ProcessingException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.base.Predicate;
import shaded.com.google.common.base.Throwables;
import shaded.com.google.common.collect.Collections2;
import shaded.com.google.common.collect.Iterables;

public class DockerCloud
extends Cloud {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerCloud.class);
    private List<DockerTemplate> templates;
    public final String serverUrl;
    public final int containerCap;
    private int connectTimeout;
    public final int readTimeout;
    public final String version;
    public final String credentialsId;
    private transient DockerClient connection;
    private static final HashMap<String, Integer> provisioningAmis = new HashMap();

    @DataBoundConstructor
    public DockerCloud(String name, List<? extends DockerTemplate> templates, String serverUrl, String containerCapStr, int connectTimeout, int readTimeout, String credentialsId, String version) {
        super(name);
        Preconditions.checkNotNull((Object)serverUrl);
        this.version = version;
        this.credentialsId = credentialsId;
        this.serverUrl = serverUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.templates = templates != null ? new ArrayList<DockerTemplate>(templates) : Collections.emptyList();
        this.containerCap = containerCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(containerCapStr);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getContainerCapStr() {
        if (this.containerCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.containerCap);
    }

    public synchronized DockerClient connect() {
        if (this.connection == null) {
            this.connection = ClientConfigBuilderForPlugin.dockerClientConfig().forCloud(this).buildClient();
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementAmiSlaveProvision(String ami) {
        HashMap<String, Integer> hashMap = provisioningAmis;
        synchronized (hashMap) {
            int currentProvisioning;
            try {
                currentProvisioning = provisioningAmis.get(ami);
            }
            catch (NullPointerException npe) {
                return;
            }
            provisioningAmis.put(ami, Math.max(currentProvisioning - 1, 0));
        }
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        try {
            LOGGER.info("Asked to provision {} slave(s) for: {}", new Object[]{excessWorkload, label});
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            List<DockerTemplate> templates = this.getTemplates(label);
            while (excessWorkload > 0 && !templates.isEmpty()) {
                DockerTemplate t;
                block6: {
                    t = templates.get(0);
                    LOGGER.info("Will provision '{}', for label: '{}', in cloud: '{}'", new Object[]{t.getDockerTemplateBase().getImage(), label, this.getDisplayName()});
                    try {
                        if (!this.addProvisionedSlave(t)) {
                            templates.remove(t);
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Bad template '{}': '{}'. Trying next template...", (Object)t.getDockerTemplateBase().getImage(), (Object)e.getMessage());
                        templates.remove(t);
                    }
                    continue;
                }
                r.add(new NodeProvisioner.PlannedNode(t.getDockerTemplateBase().getDisplayName(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                    @Override
                    public Node call() throws Exception {
                        try {
                            DockerSlave dockerSlave = DockerCloud.this.provisionWithWait(t);
                            return dockerSlave;
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error in provisioning; template='{}' for cloud='{}'", new Object[]{t, DockerCloud.this.getDisplayName(), ex});
                            throw Throwables.propagate((Throwable)ex);
                        }
                        finally {
                            DockerCloud.this.decrementAmiSlaveProvision(t.getDockerTemplateBase().getImage());
                        }
                    }
                }), t.getNumExecutors()));
                excessWorkload -= t.getNumExecutors();
            }
            return r;
        }
        catch (Exception e) {
            LOGGER.error("Exception while provisioning for label: '{}', cloud='{}'", new Object[]{label, this.getDisplayName(), e});
            return Collections.emptyList();
        }
    }

    public static String runContainer(DockerTemplate dockerTemplate, DockerClient dockerClient, DockerComputerLauncher launcher) throws DockerException, IOException {
        DockerTemplateBase dockerTemplateBase = dockerTemplate.getDockerTemplateBase();
        CreateContainerCmd containerConfig = dockerClient.createContainerCmd(dockerTemplateBase.getImage());
        dockerTemplateBase.fillContainerConfig(containerConfig);
        if (launcher != null) {
            launcher.appendContainerConfig(dockerTemplate, containerConfig);
        }
        CreateContainerResponse response = containerConfig.exec();
        String containerId = response.getId();
        StartContainerCmd startCommand = dockerClient.startContainerCmd(containerId);
        startCommand.exec();
        return containerId;
    }

    public static String runContainer(DockerTemplateBase dockerTemplateBase, DockerClient dockerClient, DockerComputerLauncher launcher) {
        CreateContainerCmd containerConfig = dockerClient.createContainerCmd(dockerTemplateBase.getImage());
        dockerTemplateBase.fillContainerConfig(containerConfig);
        CreateContainerResponse response = containerConfig.exec();
        String containerId = response.getId();
        StartContainerCmd startCommand = dockerClient.startContainerCmd(containerId);
        startCommand.exec();
        return containerId;
    }

    private DockerSlave provisionWithWait(DockerTemplate dockerTemplate) throws IOException, Descriptor.FormException {
        InspectContainerResponse ir;
        LOGGER.info("Trying to run container for {}", (Object)dockerTemplate.getDockerTemplateBase().getImage());
        String containerId = DockerCloud.runContainer(dockerTemplate, this.connect(), dockerTemplate.getLauncher());
        try {
            ir = this.connect().inspectContainerCmd(containerId).exec();
        }
        catch (ProcessingException ex) {
            this.connect().removeContainerCmd(containerId).withForce(true).exec();
            throw ex;
        }
        String nodeDescription = "Docker Node [" + dockerTemplate.getDockerTemplateBase().getImage() + " on ";
        try {
            nodeDescription = nodeDescription + this.getDisplayName();
        }
        catch (Exception ex) {
            nodeDescription = nodeDescription + "???";
        }
        nodeDescription = nodeDescription + "]";
        String slaveName = containerId.substring(0, 12);
        try {
            slaveName = this.getDisplayName() + "-" + slaveName;
        }
        catch (Exception ex) {
            LOGGER.warn("Error fetching cloud name");
        }
        dockerTemplate.getLauncher().waitUp(this.getDisplayName(), dockerTemplate, ir);
        ComputerLauncher launcher = dockerTemplate.getLauncher().getPreparedLauncher(this.getDisplayName(), dockerTemplate, ir);
        return new DockerSlave(slaveName, nodeDescription, launcher, containerId, dockerTemplate, this.getDisplayName());
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    @CheckForNull
    public DockerTemplate getTemplate(String template) {
        for (DockerTemplate t : this.templates) {
            if (!t.getDockerTemplateBase().getImage().equals(template)) continue;
            return t;
        }
        return null;
    }

    @CheckForNull
    public DockerTemplate getTemplate(Label label) {
        List<DockerTemplate> templates = this.getTemplates(label);
        if (!templates.isEmpty()) {
            return templates.get(0);
        }
        return null;
    }

    public synchronized void addTemplate(DockerTemplate t) {
        this.templates.add(t);
    }

    public List<DockerTemplate> getTemplates() {
        return this.templates;
    }

    public List<DockerTemplate> getTemplates(Label label) {
        ArrayList<DockerTemplate> dockerTemplates = new ArrayList<DockerTemplate>();
        for (DockerTemplate t : this.templates) {
            if (label == null && t.getMode() == Node.Mode.NORMAL) {
                dockerTemplates.add(t);
            }
            if (label == null || !label.matches(t.getLabelSet())) continue;
            dockerTemplates.add(t);
        }
        return dockerTemplates;
    }

    public synchronized void removeTemplate(DockerTemplate t) {
        this.templates.remove(t);
    }

    public int countCurrentDockerSlaves(String ami) throws Exception {
        final DockerClient dockerClient = this.connect();
        List containers = (List)dockerClient.listContainersCmd().exec();
        if (ami == null) {
            return containers.size();
        }
        List images = (List)dockerClient.listImagesCmd().exec();
        NameParser.ReposTag repostag = NameParser.parseRepositoryTag((String)ami);
        final String fullAmi = repostag.repos + ":" + (repostag.tag.isEmpty() ? "latest" : repostag.tag);
        boolean imageExists = Iterables.any((Iterable)images, (Predicate)new Predicate<Image>(){

            public boolean apply(Image image) {
                return Arrays.asList(image.getRepoTags()).contains(fullAmi);
            }
        });
        if (!imageExists) {
            LOGGER.info("Pulling image '{}' since one was not found.  This may take awhile...", (Object)ami);
            try (InputStream imageStream = dockerClient.pullImageCmd(ami).exec();){
                int streamValue = 0;
                while (streamValue != -1) {
                    streamValue = imageStream.read();
                }
            }
            LOGGER.info("Finished pulling image '{}'", (Object)ami);
        }
        final InspectImageResponse ir = dockerClient.inspectImageCmd(ami).exec();
        Collection matching = Collections2.filter((Collection)containers, (Predicate)new Predicate<Container>(){

            public boolean apply(@Nullable Container container) {
                InspectContainerResponse cis = dockerClient.inspectContainerCmd(container.getId()).exec();
                return cis.getImageId().equalsIgnoreCase(ir.getId());
            }
        });
        return matching.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean addProvisionedSlave(DockerTemplate t) throws Exception {
        String ami = t.getDockerTemplateBase().getImage();
        int amiCap = t.instanceCap;
        int estimatedTotalSlaves = this.countCurrentDockerSlaves(null);
        int estimatedAmiSlaves = this.countCurrentDockerSlaves(ami);
        HashMap<String, Integer> hashMap = provisioningAmis;
        synchronized (hashMap) {
            int currentProvisioning;
            for (int amiCount : provisioningAmis.values()) {
                estimatedTotalSlaves += amiCount;
            }
            try {
                currentProvisioning = provisioningAmis.get(ami);
            }
            catch (NullPointerException npe) {
                currentProvisioning = 0;
            }
            estimatedAmiSlaves += currentProvisioning;
            if (estimatedTotalSlaves >= this.containerCap) {
                LOGGER.info("Not Provisioning '{}'; Server '{}' full with '{}' container(s)", new Object[]{ami, this.containerCap, this.name});
                return false;
            }
            if (amiCap != 0 && estimatedAmiSlaves >= amiCap) {
                LOGGER.info("Not Provisioning '{}'. Instance limit of '{}' reached on server '{}'", new Object[]{ami, amiCap, this.name});
                return false;
            }
            LOGGER.info("Provisioning '{}' number '{}' on '{}'; Total containers: '{}'", new Object[]{ami, estimatedAmiSlaves, this.name, estimatedTotalSlaves});
            provisioningAmis.put(ami, currentProvisioning + 1);
            return true;
        }
    }

    public static DockerCloud getCloudByName(String name) {
        return (DockerCloud)Jenkins.getInstance().getCloud(name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("name", (Object)this.name).add("serverUrl", (Object)this.serverUrl).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DockerCloud that = (DockerCloud)((Object)o);
        if (this.containerCap != that.containerCap) {
            return false;
        }
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        if (this.readTimeout != that.readTimeout) {
            return false;
        }
        if (this.templates != null ? !this.templates.equals(that.templates) : that.templates != null) {
            return false;
        }
        if (this.serverUrl != null ? !this.serverUrl.equals(that.serverUrl) : that.serverUrl != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.credentialsId != null ? !this.credentialsId.equals(that.credentialsId) : that.credentialsId != null) {
            return false;
        }
        return !(this.connection == null ? that.connection != null : !this.connection.equals(that.connection));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Docker";
        }

        public FormValidation doTestConnection(@QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String version) throws IOException, ServletException, DockerException {
            try {
                DockerClient dc = ClientConfigBuilderForPlugin.dockerClientConfig().forServer(serverUrl, version).withCredentials(credentialsId).buildClient();
                Version verResult = (Version)dc.versionCmd().exec();
                return FormValidation.ok((String)("Version = " + verResult.getVersion()));
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            List credentials = CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (ItemGroup)context);
            return new CredentialsListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.always(), (Iterable)credentials);
        }

        public static class CredentialsListBoxModel
        extends AbstractIdCredentialsListBoxModel<CredentialsListBoxModel, StandardCertificateCredentials> {
            @NonNull
            protected String describe(@NonNull StandardCertificateCredentials c) {
                return CredentialsNameProvider.name((Credentials)c);
            }
        }
    }
}

