/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserListBoxModel;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.trilead.ssh2.Connection;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import shaded.com.google.common.base.Function;
import shaded.com.google.common.base.Joiner;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.base.Splitter;
import shaded.com.google.common.base.Strings;
import shaded.com.google.common.collect.Iterables;

public class DockerTemplateBase
implements Describable<DockerTemplateBase> {
    private static final Logger LOGGER = Logger.getLogger(DockerTemplateBase.class.getName());
    private String image;
    public final String dockerCommand;
    public final String lxcConfString;
    public final String hostname;
    public final String[] dnsHosts;
    public String[] volumes;
    @Deprecated
    public String volumesFrom;
    public String[] volumesFrom2;
    public final String[] environment;
    public final String bindPorts;
    public final boolean bindAllPorts;
    public final Integer memoryLimit;
    public final Integer cpuShares;
    public final boolean privileged;
    public final boolean tty;
    @CheckForNull
    private String macAddress;
    @CheckForNull
    private List<String> extraHosts;

    @DataBoundConstructor
    public DockerTemplateBase(String image, String dnsString, String dockerCommand, String volumesString, String volumesFromString, String environmentsString, String lxcConfString, String hostname, Integer memoryLimit, Integer cpuShares, String bindPorts, boolean bindAllPorts, boolean privileged, boolean tty, String macAddress) {
        this.setImage(image);
        this.dockerCommand = dockerCommand;
        this.lxcConfString = lxcConfString;
        this.privileged = privileged;
        this.tty = tty;
        this.hostname = hostname;
        this.bindPorts = bindPorts;
        this.bindAllPorts = bindAllPorts;
        this.memoryLimit = memoryLimit;
        this.cpuShares = cpuShares;
        this.dnsHosts = DockerTemplateBase.splitAndFilterEmpty(dnsString, " ");
        this.setVolumes(DockerTemplateBase.splitAndFilterEmpty(volumesString, "\n"));
        this.setVolumesFromString(volumesFromString);
        this.environment = DockerTemplateBase.splitAndFilterEmpty(environmentsString, " ");
        this.setMacAddress(macAddress);
    }

    protected Object readResolve() {
        if (this.volumesFrom != null) {
            if (StringUtils.isNotBlank((String)this.volumesFrom)) {
                this.setVolumesFrom2(new String[]{this.volumesFrom});
            }
            this.volumesFrom = null;
        }
        return this;
    }

    public static String[] splitAndFilterEmpty(String s, String separator) {
        if (s == null) {
            return new String[0];
        }
        List list = Splitter.on((String)separator).omitEmptyStrings().splitToList((CharSequence)s);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> splitAndFilterEmptyList(String s, String separator) {
        return Splitter.on((String)separator).omitEmptyStrings().splitToList((CharSequence)s);
    }

    public static String[] filterStringArray(String[] arr) {
        ArrayList<String> strings = new ArrayList<String>();
        if (arr != null) {
            for (String s : arr) {
                if ((s = StringUtils.stripToNull((String)s)) == null) continue;
                strings.add(s);
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    public void setImage(String image) {
        if (image == null) {
            throw new IllegalArgumentException("Image can't be null");
        }
        this.image = image.trim();
    }

    public String getImage() {
        return this.image.trim();
    }

    public String getDnsString() {
        return Joiner.on((String)" ").join((Object[])this.dnsHosts);
    }

    @CheckForNull
    public String[] getVolumes() {
        return DockerTemplateBase.filterStringArray(this.volumes);
    }

    public void setVolumes(String[] volumes) {
        this.volumes = volumes;
    }

    public String getVolumesString() {
        return Joiner.on((String)"\n").join((Object[])this.volumes);
    }

    @Deprecated
    public String getVolumesFrom() {
        return this.volumesFrom;
    }

    public String[] getVolumesFrom2() {
        return DockerTemplateBase.filterStringArray(this.volumesFrom2);
    }

    public void setVolumesFrom2(String[] volumes) {
        this.volumesFrom2 = volumes;
    }

    public void setVolumesFromString(String volumesFromString) {
        this.setVolumesFrom2(DockerTemplateBase.splitAndFilterEmpty(volumesFromString, "\n"));
    }

    public String getVolumesFromString() {
        return Joiner.on((String)"\n").join((Object[])this.getVolumesFrom2());
    }

    @CheckForNull
    public String getMacAddress() {
        return StringUtils.trimToNull((String)this.macAddress);
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = StringUtils.trimToNull((String)macAddress);
    }

    public String getDisplayName() {
        return "Image of " + this.getImage();
    }

    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    public Integer getCpuShares() {
        return this.cpuShares;
    }

    public String[] getDockerCommandArray() {
        String[] dockerCommandArray = new String[]{};
        if (this.dockerCommand != null && !this.dockerCommand.isEmpty()) {
            dockerCommandArray = this.dockerCommand.split(" ");
        }
        return dockerCommandArray;
    }

    public Iterable<PortBinding> getPortMappings() {
        if (Strings.isNullOrEmpty((String)this.bindPorts)) {
            return Collections.emptyList();
        }
        return Iterables.transform((Iterable)Splitter.on((char)' ').trimResults().omitEmptyStrings().split((CharSequence)this.bindPorts), (Function)new Function<String, PortBinding>(){

            @Nullable
            public PortBinding apply(String s) {
                return PortBinding.parse((String)s);
            }
        });
    }

    public List<LxcConf> getLxcConf() {
        ArrayList<LxcConf> temp = new ArrayList<LxcConf>();
        if (this.lxcConfString == null || this.lxcConfString.trim().equals("")) {
            return temp;
        }
        for (String item : this.lxcConfString.split(",")) {
            String[] keyValuePairs = item.split("=");
            if (keyValuePairs.length == 2) {
                LOGGER.info("lxc-conf option: " + keyValuePairs[0] + "=" + keyValuePairs[1]);
                LxcConf optN = new LxcConf();
                optN.setKey(keyValuePairs[0]);
                optN.setValue(keyValuePairs[1]);
                temp.add(optN);
                continue;
            }
            LOGGER.warning("Specified option: " + item + " is not in the form X=Y, please correct.");
        }
        return temp;
    }

    public String getEnvironmentsString() {
        return Joiner.on((String)"\n").join((Object[])this.environment);
    }

    @CheckForNull
    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    public void setExtraHosts(List<String> extraHosts) {
        this.extraHosts = extraHosts;
    }

    @DataBoundSetter
    public void setExtraHostsString(String extraHostsString) {
        this.setExtraHosts(DockerTemplateBase.splitAndFilterEmptyList(extraHostsString, "\n"));
    }

    public String getExtraHostsString() {
        if (CollectionUtils.isEmpty(this.getExtraHosts())) {
            return "";
        }
        return Joiner.on((String)"\n").join(this.getExtraHosts());
    }

    public CreateContainerCmd fillContainerConfig(CreateContainerCmd containerConfig) {
        List<String> extraHosts;
        String[] cmd;
        if (this.hostname != null && !this.hostname.isEmpty()) {
            containerConfig.withHostName(this.hostname);
        }
        if ((cmd = this.getDockerCommandArray()).length > 0) {
            containerConfig.withCmd(cmd);
        }
        containerConfig.withPortBindings((PortBinding[])Iterables.toArray(this.getPortMappings(), PortBinding.class));
        containerConfig.withPublishAllPorts(this.bindAllPorts);
        containerConfig.withPrivileged(this.privileged);
        List<LxcConf> lxcConfs = this.getLxcConf();
        if (!lxcConfs.isEmpty()) {
            containerConfig.withLxcConf((LxcConf[])Iterables.toArray(lxcConfs, LxcConf.class));
        }
        if (this.cpuShares != null && this.cpuShares > 0) {
            containerConfig.withCpuShares(this.cpuShares.intValue());
        }
        if (this.memoryLimit != null && this.memoryLimit > 0) {
            Long memoryInByte = (long)this.memoryLimit.intValue() * 1024L * 1024L;
            containerConfig.withMemoryLimit(memoryInByte.longValue());
        }
        if (this.dnsHosts.length > 0) {
            containerConfig.withDns(this.dnsHosts);
        }
        if (this.getVolumes().length > 0) {
            ArrayList<Volume> vols = new ArrayList<Volume>();
            ArrayList<Bind> binds = new ArrayList<Bind>();
            for (String vol : this.getVolumes()) {
                String[] group = vol.split(":");
                if (group.length > 1) {
                    if (group[1].equals("/")) {
                        throw new IllegalArgumentException("Invalid bind mount: destination can't be '/'");
                    }
                    binds.add(Bind.parse((String)vol));
                    continue;
                }
                if (vol.equals("/")) {
                    throw new IllegalArgumentException("Invalid volume: path can't be '/'");
                }
                vols.add(new Volume(vol));
            }
            containerConfig.withVolumes(vols.toArray(new Volume[vols.size()]));
            containerConfig.withBinds(binds.toArray(new Bind[binds.size()]));
        }
        if (this.getVolumesFrom2().length > 0) {
            ArrayList<VolumesFrom> volFrom = new ArrayList<VolumesFrom>();
            for (String volFromStr : this.getVolumesFrom2()) {
                volFrom.add(new VolumesFrom(volFromStr));
            }
            containerConfig.withVolumesFrom(volFrom.toArray(new VolumesFrom[volFrom.size()]));
        }
        containerConfig.withTty(this.tty);
        if (this.environment != null && this.environment.length > 0) {
            containerConfig.withEnv(this.environment);
        }
        if (this.getMacAddress() != null) {
            containerConfig.withMacAddress(this.getMacAddress());
        }
        if (CollectionUtils.isNotEmpty(extraHosts = this.getExtraHosts())) {
            containerConfig.withExtraHosts(extraHosts.toArray(new String[extraHosts.size()]));
        }
        return containerConfig;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("image", (Object)this.getImage()).toString();
    }

    public Descriptor<DockerTemplateBase> getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(DockerTemplateBase.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerTemplateBase> {
        public FormValidation doCheckVolumesString(@QueryParameter String volumesString) {
            try {
                String[] strings;
                for (String s : strings = DockerTemplateBase.splitAndFilterEmpty(volumesString, "\n")) {
                    if (s.equals("/")) {
                        return FormValidation.error((String)"Invalid volume: path can't be '/'");
                    }
                    String[] group = s.split(":");
                    if (group.length > 3) {
                        return FormValidation.error((String)("Wrong syntax: " + s));
                    }
                    if (group.length == 2 || group.length == 3) {
                        if (group[1].equals("/")) {
                            return FormValidation.error((String)"Invalid bind mount: destination can't be '/'");
                        }
                        Bind.parse((String)s);
                        continue;
                    }
                    if (group.length == 1) {
                        new Volume(s);
                        continue;
                    }
                    return FormValidation.error((String)("Wrong line: " + s));
                }
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVolumesFromString(@QueryParameter String volumesFromString) {
            try {
                String[] strings;
                for (String volFrom : strings = DockerTemplateBase.splitAndFilterEmpty(volumesFromString, "\n")) {
                    VolumesFrom.parse((String)volFrom);
                }
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExtraHostsString(@QueryParameter String extraHostsString) {
            List<String> extraHosts = DockerTemplateBase.splitAndFilterEmptyList(extraHostsString, "\n");
            for (String extraHost : extraHosts) {
                if (extraHost.trim().split(":").length >= 2) continue;
                return FormValidation.error((String)"Wrong extraHost {}", (Object[])new Object[]{extraHost});
            }
            return FormValidation.ok();
        }

        public static ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            return new SSHUserListBoxModel().withMatching(SSHAuthenticator.matcher(Connection.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSHLauncher.SSH_SCHEME}));
        }

        public String getDisplayName() {
            return "Docker template base";
        }
    }
}

