/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlCloudOption;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionDescriptor;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerBuilderControlOptionProvisionAndStart
extends DockerBuilderControlCloudOption {
    private final String templateId;

    @DataBoundConstructor
    public DockerBuilderControlOptionProvisionAndStart(String cloudName, String templateId) {
        super(cloudName);
        this.templateId = templateId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    public void execute(AbstractBuild<?, ?> build) throws DockerException, IOException {
        DockerTemplate template = this.getCloud(build).getTemplate(this.templateId);
        DockerClient client = this.getClient(build);
        String containerId = DockerCloud.runContainer(template.getDockerTemplateBase(), client, null);
        LOGGER.info("Starting container " + containerId);
        this.getLaunchAction(build).started(client, containerId);
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Provision & Start Container";
        }
    }
}

