/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerSimpleTemplate;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlCloudOption;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionDescriptor;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import shaded.com.google.common.base.Strings;

public class DockerBuilderControlOptionRun
extends DockerBuilderControlCloudOption {
    public final String image;
    public final String dnsString;
    public final String dockerCommand;
    public final String volumesString;
    public final String volumesFrom;
    public final String environmentsString;
    public final String lxcConfString;
    public final boolean privileged;
    public final boolean tty;
    public final String hostname;
    public final String bindPorts;
    public final Integer memoryLimit;
    public final Integer cpuShares;
    public final boolean bindAllPorts;
    public final String macAddress;

    @DataBoundConstructor
    public DockerBuilderControlOptionRun(String cloudName, String image, String lxcConfString, String dnsString, String dockerCommand, String volumesString, String volumesFrom, String environmentsString, String hostname, Integer memoryLimit, Integer cpuShares, String bindPorts, boolean bindAllPorts, boolean privileged, boolean tty, String macAddress) {
        super(cloudName);
        this.image = image;
        this.lxcConfString = lxcConfString;
        this.dnsString = dnsString;
        this.dockerCommand = dockerCommand;
        this.volumesString = volumesString;
        this.volumesFrom = volumesFrom;
        this.environmentsString = environmentsString;
        this.privileged = privileged;
        this.tty = tty;
        this.hostname = hostname;
        this.bindPorts = bindPorts;
        this.memoryLimit = memoryLimit;
        this.cpuShares = cpuShares;
        this.bindAllPorts = bindAllPorts;
        this.macAddress = macAddress;
    }

    @Override
    public void execute(AbstractBuild<?, ?> build) throws DockerException, IOException {
        DockerClient client = this.getClient(build);
        String xImage = this.expand(build, this.image);
        String xCommand = this.expand(build, this.dockerCommand);
        String xHostname = this.expand(build, this.hostname);
        LOGGER.info("Pulling image " + xImage);
        InputStream result = client.pullImageCmd(xImage).exec();
        String strResult = IOUtils.toString((InputStream)result);
        LOGGER.log(Level.INFO, "Pull result = {0}", strResult);
        LOGGER.log(Level.INFO, "Starting container for image {0}", xImage);
        DockerSimpleTemplate template = new DockerSimpleTemplate(xImage, this.dnsString, xCommand, this.volumesString, this.volumesFrom, this.environmentsString, this.lxcConfString, xHostname, this.memoryLimit, this.cpuShares, this.bindPorts, this.bindAllPorts, this.privileged, this.tty, this.macAddress);
        String containerId = DockerCloud.runContainer(template, client, null);
        LOGGER.log(Level.INFO, "Started container {0}", containerId);
        this.getLaunchAction(build).started(client, containerId);
    }

    private String expand(AbstractBuild<?, ?> build, String text) {
        try {
            if (!Strings.isNullOrEmpty((String)text)) {
                text = TokenMacro.expandAll(build, (TaskListener)TaskListener.NULL, (String)text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Run Container";
        }
    }
}

