/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserListBoxModel;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderNewTemplateBackwardCompatibility;
import com.trilead.ssh2.Connection;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.RetentionStrategy;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderNewTemplate
extends DockerBuilderNewTemplateBackwardCompatibility
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerBuilderNewTemplate.class);
    private DockerTemplate dockerTemplate;
    private int version = 1;

    @Deprecated
    public DockerBuilderNewTemplate(String image, String labelString, RetentionStrategy retentionStrategy, String remoteFs, String remoteFsMapping, String credentialsId, String idleTerminationMinutes, String sshLaunchTimeoutMinutes, String jvmOptions, String javaPath, Integer memoryLimit, Integer cpuShares, String prefixStartSlaveCmd, String suffixStartSlaveCmd, String instanceCapStr, String dnsString, String dockerCommand, String volumesString, String volumesFrom, String environmentsString, String lxcConfString, String hostname, String bindPorts, boolean bindAllPorts, boolean privileged, boolean tty, String macAddress) {
        this.image = image;
        this.labelString = labelString;
        this.retentionStrategy = retentionStrategy;
        this.remoteFs = remoteFs;
        this.remoteFsMapping = remoteFsMapping;
        this.credentialsId = credentialsId;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.sshLaunchTimeoutMinutes = sshLaunchTimeoutMinutes;
        this.jvmOptions = jvmOptions;
        this.javaPath = javaPath;
        this.memoryLimit = memoryLimit;
        this.cpuShares = cpuShares;
        this.prefixStartSlaveCmd = prefixStartSlaveCmd;
        this.suffixStartSlaveCmd = suffixStartSlaveCmd;
        this.instanceCapStr = instanceCapStr;
        this.dnsString = dnsString;
        this.dockerCommand = dockerCommand;
        this.volumesString = volumesString;
        this.volumesFrom = volumesFrom;
        this.environmentsString = environmentsString;
        this.lxcConfString = lxcConfString;
        this.bindPorts = bindPorts;
        this.bindAllPorts = bindAllPorts;
        this.privileged = privileged;
        this.tty = tty;
        this.hostname = hostname;
        this.macAddress = macAddress;
        this.convert1();
        this.version = 1;
    }

    @DataBoundConstructor
    public DockerBuilderNewTemplate(DockerTemplate dockerTemplate) {
        this.dockerTemplate = dockerTemplate;
    }

    public DockerTemplate getDockerTemplate() {
        return this.dockerTemplate;
    }

    @Override
    public void setDockerTemplate(DockerTemplate dockerTemplate) {
        this.dockerTemplate = dockerTemplate;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream llogger = listener.getLogger();
        String dockerImage = this.dockerTemplate.getDockerTemplateBase().getImage();
        for (Cloud c : Jenkins.getInstance().clouds) {
            DockerCloud dockerCloud;
            if (!(c instanceof DockerCloud) || dockerImage == null || (dockerCloud = (DockerCloud)c).getTemplate(dockerImage) != null) continue;
            LOGGER.info("Adding new template: '{}', to cloud: '{}'", (Object)dockerImage, (Object)dockerCloud.name);
            llogger.println("Adding new template: '" + dockerImage + "', to cloud: '" + dockerCloud.name + "'");
            dockerCloud.addTemplate(this.dockerTemplate);
        }
        return true;
    }

    public Object readResolve() {
        try {
            if (this.version < 1) {
                this.convert1();
                this.version = 1;
            }
        }
        catch (Throwable t) {
            LOGGER.error("Can't migrate configuration to version 1", t);
        }
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Add a new template to all docker clouds";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            return new SSHUserListBoxModel().withMatching(SSHAuthenticator.matcher(Connection.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSHLauncher.SSH_SCHEME}));
        }
    }
}

