/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.core.DockerClientConfig;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.action.DockerBuildImageAction;
import com.nirima.jenkins.plugins.docker.client.ClientBuilderForPlugin;
import com.nirima.jenkins.plugins.docker.client.ClientConfigBuilderForPlugin;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import shaded.com.google.common.base.Joiner;
import shaded.com.google.common.base.Optional;
import shaded.com.google.common.base.Splitter;
import shaded.com.google.common.base.Throwables;

public class DockerBuilderPublisher
extends Builder
implements Serializable {
    private static final Pattern VALID_REPO_PATTERN = Pattern.compile("^([a-z0-9-_.]+)$");
    public final String dockerFileDirectory;
    @Deprecated
    public String tag;
    @CheckForNull
    private List<String> tags;
    public final boolean pushOnSuccess;
    public final boolean cleanImages;
    public final boolean cleanupWithJenkinsJobDelete;

    @DataBoundConstructor
    public DockerBuilderPublisher(String dockerFileDirectory, String tagsString, boolean pushOnSuccess, boolean cleanImages, boolean cleanupWithJenkinsJobDelete) {
        this.dockerFileDirectory = dockerFileDirectory;
        this.setTagsString(tagsString);
        this.tag = null;
        this.pushOnSuccess = pushOnSuccess;
        this.cleanImages = cleanImages;
        this.cleanupWithJenkinsJobDelete = cleanupWithJenkinsJobDelete;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getTagsString() {
        return this.getTags() == null ? "" : Joiner.on((String)"\n").join(this.getTags());
    }

    public void setTagsString(String tagsString) {
        this.setTags(DockerBuilderPublisher.filterStringToList(tagsString));
    }

    public static List<String> filterStringToList(String str) {
        return str == null ? null : Splitter.on((String)"\n").omitEmptyStrings().trimResults().splitToList((CharSequence)str);
    }

    public static void verifyTags(String tagsString) {
        List<String> verifyTags = DockerBuilderPublisher.filterStringToList(tagsString);
        for (String verifyTag : verifyTags) {
            if (VALID_REPO_PATTERN.matcher(verifyTag).matches()) continue;
            throw new IllegalArgumentException("Tag " + verifyTag + " doesn't match ^([a-z0-9-_.]+)$");
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new Run(build, launcher, listener).run();
    }

    private Optional<String> getImageId(String response) {
        for (String item : response.split("\n")) {
            if (!item.contains("Successfully built")) continue;
            String id = StringUtils.substringAfterLast((String)item, (String)"Successfully built ").trim();
            id = id.substring(0, 12);
            return Optional.of((Object)id);
        }
        return Optional.absent();
    }

    private String getUrl(AbstractBuild build) {
        Node node = build.getBuiltOn();
        if (node instanceof DockerSlave) {
            DockerSlave slave = (DockerSlave)node;
            return slave.getCloud().serverUrl;
        }
        return null;
    }

    private List<String> expandTags(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList<String> eTags = new ArrayList<String>(this.tags.size());
        for (String tag : this.tags) {
            try {
                eTags.add(TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)tag));
            }
            catch (IOException | InterruptedException | MacroEvaluationException e) {
                listener.getLogger().println("Couldn't macro expand tag " + tag);
            }
        }
        return eTags;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckTagsString(@QueryParameter String tagsString) {
            try {
                DockerBuilderPublisher.verifyTags(tagsString);
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Build / Publish Docker Containers";
        }
    }

    class Run
    implements Serializable {
        final transient AbstractBuild build;
        final transient Launcher launcher;
        final BuildListener listener;
        FilePath fpChild;
        final List<String> tagsToUse;
        final String url;
        private transient DockerClient _client;
        final DockerClientConfig clientConfig;

        Run(AbstractBuild build, Launcher launcher, BuildListener listener) {
            this.build = build;
            this.launcher = launcher;
            this.listener = listener;
            this.fpChild = new FilePath(build.getWorkspace(), DockerBuilderPublisher.this.dockerFileDirectory);
            this.tagsToUse = DockerBuilderPublisher.this.expandTags(build, launcher, listener);
            this.url = DockerBuilderPublisher.this.getUrl(build);
            Optional<DockerCloud> cloudThatBuildRanOn = this.getCloudForBuild(build);
            this.clientConfig = cloudThatBuildRanOn.isPresent() ? ClientConfigBuilderForPlugin.dockerClientConfig().forCloud((DockerCloud)((Object)cloudThatBuildRanOn.get())).build() : null;
        }

        public Optional<DockerCloud> getCloudForBuild(AbstractBuild build) {
            Node node = build.getBuiltOn();
            if (node instanceof DockerSlave) {
                DockerSlave slave = (DockerSlave)node;
                return Optional.of((Object)((Object)slave.getCloud()));
            }
            return Optional.absent();
        }

        private DockerClient getClient() {
            if (this._client == null) {
                if (this.clientConfig == null) {
                    throw new RuntimeException("Could not get client because we could not find the cloud that the project was built on. What this build run on Docker?");
                }
                this._client = ClientBuilderForPlugin.getInstance(this.clientConfig).build();
            }
            return this._client;
        }

        boolean run() throws IOException, InterruptedException {
            this.listener.getLogger().println("Docker Build");
            String response = this.buildImage();
            this.listener.getLogger().println("Docker Build Response : " + response);
            Optional id = DockerBuilderPublisher.this.getImageId(response);
            if (!id.isPresent()) {
                return false;
            }
            this.build.addAction((Action)new DockerBuildImageAction(this.url, (String)id.get(), this.tagsToUse, DockerBuilderPublisher.this.cleanupWithJenkinsJobDelete, DockerBuilderPublisher.this.pushOnSuccess));
            this.build.save();
            if (DockerBuilderPublisher.this.pushOnSuccess) {
                this.listener.getLogger().println("Pushing " + this.tagsToUse);
                String stringResponse = this.pushImages();
                this.listener.getLogger().println("Docker Push Response : " + stringResponse);
            }
            if (DockerBuilderPublisher.this.cleanImages) {
                this.listener.getLogger().println("Cleaning local images [" + (String)id.get() + "]");
                try {
                    this.cleanImages((String)id.get());
                }
                catch (Exception ex) {
                    this.listener.getLogger().println("Error attempting to clean images");
                }
            }
            this.listener.getLogger().println("Docker Build Done");
            return true;
        }

        private void cleanImages(String id) {
            this.getClient().removeImageCmd(id).withForce().exec();
        }

        private String buildImage() throws IOException, InterruptedException {
            return (String)this.fpChild.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

                public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                    try {
                        Run.this.listener.getLogger().println("Docker Build : build with tags " + Run.this.tagsToUse.toString() + " at path " + f.getAbsolutePath());
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        for (String tag : Run.this.tagsToUse) {
                            Run.this.listener.getLogger().println("Docker Build : building tag " + tag);
                            try {
                                InputStream is = (InputStream)Run.this.getClient().buildImageCmd(f).withTag(tag).exec();
                                IOUtils.copy((InputStream)is, (OutputStream)baos);
                            }
                            catch (Exception ex) {
                                Run.this.listener.getLogger().println(ex.getMessage());
                                ex.printStackTrace(Run.this.listener.getLogger());
                                Run.this.listener.getLogger().println("Error attempting to tag " + tag + ". Continuing anyway.");
                            }
                        }
                        return baos.toString();
                    }
                    catch (DockerException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            });
        }

        private String pushImages() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (String tagToUse : this.tagsToUse) {
                if (!tagToUse.toLowerCase().equals(tagToUse)) {
                    this.listener.getLogger().println("ERROR: Docker will refuse to push tag name " + tagToUse + " because it uses upper case.");
                }
                Identifier identifier = Identifier.fromCompoundString((String)tagToUse);
                PushImageCmd pushImageCmd = this.getClient().pushImageCmd(identifier);
                PushImageCmd.Response pushResponse = pushImageCmd.exec();
                IOUtils.copy((InputStream)pushResponse, (OutputStream)byteArrayOutputStream);
            }
            return byteArrayOutputStream.toString();
        }
    }
}

