/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.launcher;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.nirima.jenkins.plugins.docker.DockerComputer;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerLauncher;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import jenkins.model.Jenkins;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.annotations.Beta;

@Beta
public class DockerComputerJNLPLauncher
extends DockerComputerLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerComputerJNLPLauncher.class);
    protected JNLPLauncher jnlpLauncher;
    protected long launchTimeout = 120L;
    protected String user;
    @Restricted(value={NoExternalUse.class})
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public DockerComputerJNLPLauncher(JNLPLauncher jnlpLauncher) {
        this.jnlpLauncher = jnlpLauncher;
    }

    public JNLPLauncher getJnlpLauncher() {
        return this.jnlpLauncher;
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        String containerId;
        DockerComputer dockerComputer;
        PrintStream logger;
        block10: {
            logger = listener.getLogger();
            dockerComputer = (DockerComputer)computer;
            containerId = dockerComputer.getContainerId();
            String rootUrl = Jenkins.getInstance().getRootUrl();
            DockerClient connect = dockerComputer.getCloud().connect();
            DockerTemplate dockerTemplate = ((DockerSlave)dockerComputer.getNode()).getDockerTemplate();
            String startCmd = "cat << EOF > /tmp/config.sh.tmp && cd /tmp && mv config.sh.tmp config.sh\nJENKINS_URL=\"" + rootUrl + "\"\n" + "JENKINS_USER=\"" + this.getUser() + "\"\n" + "JENKINS_HOME=\"" + dockerTemplate.getRemoteFs() + "\"\n" + "COMPUTER_URL=\"" + dockerComputer.getUrl() + "\"\n" + "COMPUTER_SECRET=\"" + dockerComputer.getJnlpMac() + "\"\n" + "EOF" + "\n";
            try {
                ExecCreateCmdResponse response = (ExecCreateCmdResponse)connect.execCreateCmd(containerId).withTty().withAttachStdin().withAttachStderr().withAttachStdout().withCmd(new String[]{"/bin/bash", "-cxe", startCmd.replace("$", "\\$")}).exec();
                LOGGER.info("Starting connection command for {}", (Object)containerId);
                logger.println("Starting connection command for " + containerId);
                try {
                    InputStream exec = connect.execStartCmd(response.getId()).withDetach().withTty().exec();
                    Throwable throwable = null;
                    if (exec == null) break block10;
                    if (throwable != null) {
                        try {
                            exec.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        break block10;
                    }
                    exec.close();
                }
                catch (NotFoundException ex) {
                    listener.error("Can't execute command: " + ex.getMessage());
                    LOGGER.error("Can't execute jnlp connection command: '{}'", (Object)ex.getMessage());
                }
            }
            catch (Exception ex) {
                listener.error("Can't execute command: " + ex.getMessage());
                LOGGER.error("Can't execute jnlp connection command: '{}'", (Object)ex.getMessage());
                throw ex;
            }
        }
        LOGGER.info("Successfully executed jnlp connection for '{}'", (Object)containerId);
        logger.println("Successfully executed jnlp connection for " + containerId);
        long launchTime = System.currentTimeMillis();
        while (!dockerComputer.isOnline() && TimeUnit2.SECONDS.toMillis(this.launchTimeout) > System.currentTimeMillis() - launchTime) {
            logger.println("Waiting slave connection...");
            Thread.sleep(1000L);
        }
        if (!dockerComputer.isOnline()) {
            LOGGER.info("Launch timeout, termintaing slave based on '{}'", (Object)containerId);
            logger.println("Launch timeout, termintaing slave.");
            ((DockerSlave)dockerComputer.getNode()).terminate();
            throw new IOException("Can't connect slave to jenkins");
        }
        LOGGER.info("Launched slave '{}' based on '{}'", (Object)dockerComputer.getName(), (Object)containerId);
        logger.println("Launched slave for " + containerId);
    }

    @Override
    public ComputerLauncher getPreparedLauncher(String cloudId, DockerTemplate template, InspectContainerResponse containerInspectResponse) {
        return new DockerComputerJNLPLauncher(this.getJnlpLauncher());
    }

    @Override
    public void appendContainerConfig(DockerTemplate dockerTemplate, CreateContainerCmd createContainerCmd) throws IOException {
        try (InputStream istream = DockerComputerJNLPLauncher.class.getResourceAsStream("DockerComputerJNLPLauncher/init.sh");){
            String initCmd = IOUtils.toString((InputStream)istream, (Charset)Charsets.UTF_8);
            if (initCmd == null) {
                throw new IllegalStateException("Resource file 'init.sh' not found");
            }
            createContainerCmd.withCmd(new String[]{"/bin/bash", "-cxe", "cat << EOF >> /tmp/init.sh && chmod +x /tmp/init.sh && exec /tmp/init.sh\n" + initCmd.replace("$", "\\$") + "\n" + "EOF" + "\n"});
        }
        createContainerCmd.withTty(true);
        createContainerCmd.withStdinOpen(true);
    }

    @Override
    public boolean waitUp(String cloudId, DockerTemplate dockerTemplate, InspectContainerResponse ir) {
        return super.waitUp(cloudId, dockerTemplate, ir);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public Class getJNLPLauncher() {
            return JNLPLauncher.class;
        }

        public String getDisplayName() {
            return "(Experimental) Docker JNLP launcher";
        }
    }
}

