/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.launcher;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerLauncher;
import com.nirima.jenkins.plugins.docker.utils.PortUtils;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.plugins.sshslaves.SSHConnector;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import shaded.com.google.common.annotations.Beta;
import shaded.com.google.common.base.Preconditions;

@Beta
public class DockerComputerSSHLauncher
extends DockerComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(DockerComputerSSHLauncher.class.getName());
    protected final SSHConnector sshConnector;
    @Restricted(value={NoExternalUse.class})
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public DockerComputerSSHLauncher(SSHConnector sshConnector) {
        this.sshConnector = sshConnector;
    }

    public SSHConnector getSshConnector() {
        return this.sshConnector;
    }

    @Override
    public ComputerLauncher getPreparedLauncher(String cloudId, DockerTemplate dockerTemplate, InspectContainerResponse inspect) {
        DockerComputerSSHLauncher prepLauncher = new DockerComputerSSHLauncher(null);
        prepLauncher.setLauncher((ComputerLauncher)this.getSSHLauncher(cloudId, dockerTemplate, inspect));
        return prepLauncher;
    }

    @Override
    public void appendContainerConfig(DockerTemplate dockerTemplate, CreateContainerCmd createCmd) {
        int sshPort = this.getSshConnector().port;
        createCmd.withPortSpecs(new String[]{sshPort + "/tcp"});
        String[] cmd = dockerTemplate.getDockerTemplateBase().getDockerCommandArray();
        if (cmd.length == 0) {
            createCmd.withCmd(new String[]{"bash", "-c", "/usr/sbin/sshd -D -p " + sshPort});
        }
        createCmd.getPortBindings().add(new PortBinding[]{PortBinding.parse((String)("0.0.0.0::" + sshPort))});
    }

    @Override
    public boolean waitUp(String cloudId, DockerTemplate dockerTemplate, InspectContainerResponse containerInspect) {
        super.waitUp(cloudId, dockerTemplate, containerInspect);
        PortUtils portUtils = this.getPortUtils(cloudId, dockerTemplate, containerInspect);
        if (!portUtils.withEveryRetryWaitFor(10, TimeUnit.SECONDS)) {
            return false;
        }
        try {
            portUtils.bySshWithEveryRetryWaitFor(10, TimeUnit.SECONDS);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Can't connect to ssh", ex);
            return false;
        }
        return true;
    }

    private SSHLauncher getSSHLauncher(String cloudId, DockerTemplate template, InspectContainerResponse inspect) {
        Preconditions.checkNotNull((Object)template);
        Preconditions.checkNotNull((Object)inspect);
        try {
            PortUtils portUtils = this.getPortUtils(cloudId, template, inspect);
            LOGGER.log(Level.INFO, "Creating slave SSH launcher for " + portUtils.host + ":" + portUtils.port);
            return new SSHLauncher(portUtils.host, portUtils.port, this.sshConnector.getCredentials(), this.sshConnector.jvmOptions, this.sshConnector.javaPath, this.sshConnector.prefixStartSlaveCmd, this.sshConnector.suffixStartSlaveCmd, this.sshConnector.launchTimeoutSeconds);
        }
        catch (NullPointerException ex) {
            throw new RuntimeException("No mapped port 22 in host for SSL. Config=" + inspect, ex);
        }
    }

    public PortUtils getPortUtils(String cloudId, DockerTemplate dockerTemplate, InspectContainerResponse ir) {
        Ports.Binding[] sshBindings;
        ExposedPort sshPort = new ExposedPort(this.sshConnector.port);
        String host = null;
        Integer port = 22;
        InspectContainerResponse.NetworkSettings networkSettings = ir.getNetworkSettings();
        Ports ports = networkSettings.getPorts();
        Map bindings = ports.getBindings();
        for (Ports.Binding b : sshBindings = (Ports.Binding[])bindings.get(sshPort)) {
            port = b.getHostPort();
            host = b.getHostIp();
        }
        if (host == null || host.equals("0.0.0.0")) {
            host = URI.create(DockerCloud.getCloudByName((String)cloudId).serverUrl).getHost();
        }
        return PortUtils.canConnect(host, port);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            return DockerTemplateBase.DescriptorImpl.doFillCredentialsIdItems(context);
        }

        public Class getSshConnectorClass() {
            return SSHConnector.class;
        }

        public String getDisplayName() {
            return "Docker SSH computer launcher";
        }
    }
}

