/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.strategy;

import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.EphemeralNode;
import hudson.slaves.RetentionStrategy;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.durabletask.executors.ContinuableExecutable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerOnceRetentionStrategy
extends CloudRetentionStrategy
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(DockerOnceRetentionStrategy.class.getName());
    private int idleMinutes = 10;
    private transient boolean terminating;
    @Restricted(value={NoExternalUse.class})
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public DockerOnceRetentionStrategy(int idleMinutes) {
        super(idleMinutes);
        this.idleMinutes = idleMinutes;
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    public long check(AbstractCloudComputer c) {
        long idleMilliseconds;
        if (c.isIdle() && !disabled && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > TimeUnit2.MINUTES.toMillis((long)this.idleMinutes)) {
            LOGGER.log(Level.FINE, "Disconnecting {0}", c.getName());
            this.done(c);
        }
        return 1L;
    }

    public void start(AbstractCloudComputer c) {
        if (c.getNode() instanceof EphemeralNode) {
            throw new IllegalStateException("May not use OnceRetentionStrategy on an EphemeralNode: " + c);
        }
        super.start(c);
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.done(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.done(executor);
    }

    private void done(Executor executor) {
        AbstractCloudComputer c = (AbstractCloudComputer)executor.getOwner();
        Queue.Executable exec = executor.getCurrentExecutable();
        if (exec instanceof ContinuableExecutable && ((ContinuableExecutable)exec).willContinue()) {
            LOGGER.log(Level.FINE, "not terminating {0} because {1} says it will be continued", new Object[]{c.getName(), exec});
            return;
        }
        LOGGER.log(Level.FINE, "terminating {0} since {1} seems to be finished", new Object[]{c.getName(), exec});
        this.done(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done(final AbstractCloudComputer<?> c) {
        c.setAcceptingTasks(false);
        DockerOnceRetentionStrategy dockerOnceRetentionStrategy = this;
        synchronized (dockerOnceRetentionStrategy) {
            if (this.terminating) {
                return;
            }
            this.terminating = true;
        }
        Computer.threadPoolForRemoting.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DockerOnceRetentionStrategy queue;
                Jenkins jenkins = Jenkins.getInstance();
                DockerOnceRetentionStrategy dockerOnceRetentionStrategy = queue = jenkins == null ? DockerOnceRetentionStrategy.this : jenkins.getQueue();
                synchronized (dockerOnceRetentionStrategy) {
                    try {
                        AbstractCloudSlave node = c.getNode();
                        if (node != null) {
                            node.terminate();
                        }
                    }
                    catch (IOException | InterruptedException e) {
                        LOGGER.log(Level.WARNING, "Failed to terminate " + c.getName(), e);
                        DockerOnceRetentionStrategy dockerOnceRetentionStrategy2 = DockerOnceRetentionStrategy.this;
                        synchronized (dockerOnceRetentionStrategy2) {
                            DockerOnceRetentionStrategy.this.terminating = false;
                        }
                    }
                }
            }
        });
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "Docker Once Retention Strategy";
        }
    }
}

