/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.utils;

import com.trilead.ssh2.Connection;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.base.Preconditions;

public class PortUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortUtils.class);
    public final String host;
    public final int port;
    private int retries = 10;
    private int sshTimeoutMillis = (int)TimeUnit.SECONDS.toMillis(2L);

    private PortUtils(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static PortUtils canConnect(String host, int port) {
        return new PortUtils(host, port);
    }

    public PortUtils withRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public PortUtils withSshTimeout(int time, TimeUnit units) {
        this.sshTimeoutMillis = (int)units.toMillis(time);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean now() {
        try (Socket ignored = new Socket(this.host, this.port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean withEveryRetryWaitFor(int time, TimeUnit units) {
        for (int i = 1; i <= this.retries; ++i) {
            if (this.now()) {
                return true;
            }
            PortUtils.sleepFor(time, units);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bySshWithEveryRetryWaitFor(int time, TimeUnit units) throws IOException {
        Preconditions.checkState((boolean)this.withEveryRetryWaitFor(time, units), (String)"Port %s is not opened to connect to", (Object[])new Object[]{this.port});
        for (int i = 1; i <= this.retries; ++i) {
            try (Connection connection = new Connection(this.host, this.port);){
                connection.connect(null, 0, this.sshTimeoutMillis, this.sshTimeoutMillis);
                LOGGER.info("SSH port is open on {}:{}", (Object)this.host, (Object)this.port);
                return;
            }
            PortUtils.sleepFor(time, units);
        }
    }

    public static void sleepFor(int time, TimeUnit units) {
        try {
            LOGGER.trace("Sleeping for {} {}", (Object)time, (Object)units.toString());
            Thread.sleep(units.toMillis(time));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

