/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.nirima.jenkins.plugins.docker.DockerComputer;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildVariableContributor;
import hudson.model.Executor;
import java.net.URISyntaxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.http.client.utils.URIBuilder;

@Extension
public class DockerBuildVariableContributor
extends BuildVariableContributor {
    private static final Logger LOG = LoggerFactory.getLogger(DockerBuildVariableContributor.class);

    public void buildVariablesFor(AbstractBuild build, Map<String, String> variables) {
        Executor executor = build.getExecutor();
        if (executor != null && executor.getOwner() instanceof DockerComputer) {
            DockerComputer dockerComputer = (DockerComputer)executor.getOwner();
            variables.put("DOCKER_CONTAINER_ID", dockerComputer.getContainerId());
            variables.put("JENKINS_CLOUD_ID", dockerComputer.getCloudId());
            try {
                URIBuilder uriBuilder = new URIBuilder(dockerComputer.getCloud().serverUrl);
                if (!uriBuilder.getScheme().equals("unix")) {
                    uriBuilder.setScheme("tcp");
                }
                String dockerHost = uriBuilder.toString();
                variables.put("DOCKER_HOST", dockerHost);
            }
            catch (URISyntaxException e) {
                LOG.error("Can't build 'DOCKER_HOST' var: {}", (Object)e.getMessage());
            }
        }
    }
}

