/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.nirima.jenkins.plugins.docker.DockerRegistry;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.Collections;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class DockerPluginConfiguration
extends GlobalConfiguration {
    private Boolean pullFix;
    private List<DockerRegistry> registryList = Collections.emptyList();

    public static DockerPluginConfiguration get() {
        return (DockerPluginConfiguration)((Object)GlobalConfiguration.all().get(DockerPluginConfiguration.class));
    }

    public DockerPluginConfiguration() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return true;
    }

    public final boolean getPullFix() {
        if (this.pullFix == null) {
            this.pullFix = true;
        }
        return this.pullFix;
    }

    public DockerRegistry getRegistryByName(String registryName) {
        for (DockerRegistry registry : this.registryList) {
            if (!registry.registry.equalsIgnoreCase(registryName)) continue;
            return registry;
        }
        return null;
    }

    public final void setPullFix(boolean pullFix) {
        this.pullFix = pullFix;
        this.save();
    }

    public void setRegistryList(List<DockerRegistry> registryList) {
        this.registryList = registryList;
        this.save();
    }

    public List<DockerRegistry> getRegistryList() {
        return this.registryList;
    }
}

