/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerClientException;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerComputer;
import com.nirima.jenkins.plugins.docker.DockerJobProperty;
import com.nirima.jenkins.plugins.docker.DockerOfflineCause;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.action.DockerBuildAction;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import com.nirima.jenkins.plugins.docker.utils.LogUtils;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.base.Strings;

public class DockerSlave
extends AbstractCloudSlave {
    private static final Logger LOGGER = Logger.getLogger(DockerSlave.class.getName());
    public DockerTemplate dockerTemplate;
    @CheckForNull
    private String containerId;
    @CheckForNull
    private String cloudId;
    private transient Run theRun;

    public DockerSlave(DockerTemplate dockerTemplate, String containerId, String name, String nodeDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, nodeProperties);
        Preconditions.checkNotNull((Object)dockerTemplate);
        Preconditions.checkNotNull((Object)containerId);
        this.setDockerTemplate(dockerTemplate);
        this.containerId = containerId;
    }

    public DockerSlave(String slaveName, String nodeDescription, ComputerLauncher launcher, String containerId, DockerTemplate dockerTemplate, String cloudId) throws IOException, Descriptor.FormException {
        super(slaveName, nodeDescription, dockerTemplate.getRemoteFs(), dockerTemplate.getNumExecutors(), dockerTemplate.getMode(), dockerTemplate.getLabelString(), launcher, dockerTemplate.getRetentionStrategyCopy(), Collections.emptyList());
        this.setContainerId(containerId);
        this.setDockerTemplate(dockerTemplate);
        this.setCloudId(cloudId);
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public DockerTemplate getDockerTemplate() {
        return this.dockerTemplate;
    }

    public void setDockerTemplate(DockerTemplate dockerTemplate) {
        this.dockerTemplate = dockerTemplate;
    }

    public DockerCloud getCloud() {
        Cloud cloud = Jenkins.getInstance().getCloud(this.getCloudId());
        if (cloud == null) {
            throw new RuntimeException("Docker template " + this.dockerTemplate + " has no assigned Cloud.");
        }
        if (cloud.getClass() != DockerCloud.class) {
            throw new RuntimeException("Assigned cloud is not DockerCloud");
        }
        return (DockerCloud)cloud;
    }

    public String getDisplayName() {
        return this.name;
    }

    public void setRun(Run run) {
        this.theRun = run;
    }

    public DockerComputer createComputer() {
        return new DockerComputer(this);
    }

    public CauseOfBlockage canTake(Queue.BuildableItem item) {
        if (item.task instanceof Queue.FlyweightTask) {
            return new CauseOfBlockage(){

                public String getShortDescription() {
                    return "Don't run FlyweightTask on Docker node";
                }
            };
        }
        return super.canTake(item);
    }

    public boolean containerExistsInCloud() {
        try {
            DockerClient client = this.getClient();
            client.inspectContainerCmd(this.containerId).exec();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        try {
            this.toComputer().disconnect((OfflineCause)new DockerOfflineCause());
            LOGGER.log(Level.INFO, "Disconnected computer");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Can't disconnect", e);
        }
        if (this.containerId != null) {
            DockerClient client;
            try {
                client = this.getClient();
                client.stopContainerCmd(this.getContainerId()).exec();
                LOGGER.log(Level.INFO, "Stopped container {0}", this.getContainerId());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to stop instance " + this.getContainerId() + " for slave " + this.name + " due to exception", ex.getMessage());
            }
            if (this.theRun != null) {
                try {
                    this.slaveShutdown(listener);
                    LOGGER.log(Level.INFO, "Shutdowned slave for {0}", this.getContainerId());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failure to slaveShutdown instance " + this.getContainerId() + " for slave " + this.name, e);
                }
            }
            try {
                client = this.getClient();
                client.removeContainerCmd(this.containerId).withRemoveVolumes(this.getDockerTemplate().isRemoveVolumes()).exec();
                LOGGER.log(Level.INFO, "Removed container {0}", this.getContainerId());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to remove instance " + this.getContainerId() + " for slave " + this.name + " due to exception: " + ex.getMessage());
            }
        } else {
            LOGGER.log(Level.SEVERE, "ContainerId is absent, no way to remove/stop container");
        }
    }

    private void slaveShutdown(final TaskListener listener) throws DockerException, IOException {
        String tag_image;
        DockerClient client;
        block7: {
            if (!this.getJobProperty().tagOnCompletion) {
                this.addJenkinsAction(null);
                return;
            }
            client = this.getClient();
            tag_image = client.commitCmd(this.containerId).withRepository(this.theRun.getParent().getDisplayName()).withTag(this.theRun.getDisplayName().replace("#", "b")).withAuthor("Jenkins").exec();
            this.addJenkinsAction(tag_image);
            try {
                String tagToken = this.getAdditionalTag(listener);
                if (Strings.isNullOrEmpty((String)tagToken)) break block7;
                NameParser.ReposTag reposTag = NameParser.parseRepositoryTag((String)tagToken);
                String commitTag = StringUtils.isEmpty((String)reposTag.tag) ? "latest" : reposTag.tag;
                this.getClient().tagImageCmd(tag_image, reposTag.repos, commitTag).withForce().exec();
                this.addJenkinsAction(tagToken);
                if (!this.getJobProperty().pushOnSuccess) break block7;
                Identifier identifier = Identifier.fromCompoundString((String)tagToken);
                PushImageResultCallback resultCallback = new PushImageResultCallback(){

                    public void onNext(PushResponseItem item) {
                        LogUtils.printResponseItemToListener(listener, (ResponseItem)item);
                        super.onNext(item);
                    }
                };
                try {
                    PushImageCmd cmd = this.getClient().pushImageCmd(identifier);
                    AuthConfig authConfig = JenkinsUtils.getAuthConfigFor(tagToken);
                    if (authConfig != null) {
                        cmd.withAuthConfig(authConfig);
                    }
                    ((PushImageResultCallback)cmd.exec((ResultCallback)resultCallback)).awaitSuccess();
                }
                catch (DockerClientException ex) {
                    LOGGER.log(Level.SEVERE, "Exception pushing docker image. Check that the destination registry is running.");
                    throw ex;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Could not add additional tags");
            }
        }
        if (this.getJobProperty().cleanImages) {
            client.removeImageCmd(tag_image).withForce().exec();
        }
    }

    private String getAdditionalTag(TaskListener listener) {
        String tagToken = this.getJobProperty().additionalTag;
        try {
            if (!Strings.isNullOrEmpty((String)tagToken)) {
                tagToken = TokenMacro.expandAll((AbstractBuild)((AbstractBuild)this.theRun), (TaskListener)listener, (String)tagToken);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "can't expand macroses", e);
        }
        return tagToken;
    }

    private void addJenkinsAction(String tag_image) throws IOException {
        this.theRun.addAction((Action)new DockerBuildAction(this.getCloud().serverUrl, this.containerId, tag_image, this.dockerTemplate.remoteFsMapping));
        this.theRun.save();
    }

    public DockerClient getClient() {
        return this.getCloud().getClient();
    }

    private DockerJobProperty getJobProperty() {
        try {
            DockerJobProperty p = (DockerJobProperty)((AbstractBuild)this.theRun).getProject().getProperty(DockerJobProperty.class);
            if (p != null) {
                return p;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DockerJobProperty(false, null, false, true);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("name", (Object)this.name).add("containerId", (Object)this.containerId).add("template", (Object)this.dockerTemplate).toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Docker Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

