/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.nirima.jenkins.plugins.docker.DockerImagePullStrategy;
import com.nirima.jenkins.plugins.docker.DockerTemplateBackwardCompatibility;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerLauncher;
import com.nirima.jenkins.plugins.docker.strategy.DockerOnceRetentionStrategy;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.base.Strings;

public class DockerTemplate
extends DockerTemplateBackwardCompatibility
implements Describable<DockerTemplate> {
    private static final Logger LOGGER = Logger.getLogger(DockerTemplate.class.getName());
    private int configVersion = 2;
    private final String labelString;
    private DockerComputerLauncher launcher;
    public final String remoteFsMapping;
    public String remoteFs = "/home/jenkins";
    public final int instanceCap;
    private Node.Mode mode = Node.Mode.NORMAL;
    private RetentionStrategy retentionStrategy = new DockerOnceRetentionStrategy(10);
    private int numExecutors = 1;
    private DockerTemplateBase dockerTemplateBase;
    private boolean removeVolumes;
    private transient Set<LabelAtom> labelSet;
    @CheckForNull
    private DockerImagePullStrategy pullStrategy = DockerImagePullStrategy.PULL_LATEST;

    public DockerTemplate() {
        this.labelString = "";
        this.remoteFsMapping = "";
        this.instanceCap = 1;
    }

    @DataBoundConstructor
    public DockerTemplate(DockerTemplateBase dockerTemplateBase, String labelString, String remoteFs, String remoteFsMapping, String instanceCapStr) {
        this.dockerTemplateBase = dockerTemplateBase;
        this.labelString = Util.fixNull((String)labelString);
        this.remoteFs = Strings.isNullOrEmpty((String)remoteFs) ? "/home/jenkins" : remoteFs;
        this.remoteFsMapping = remoteFsMapping;
        this.instanceCap = instanceCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        this.labelSet = Label.parse((String)labelString);
    }

    @Restricted(value={NoExternalUse.class})
    public DockerTemplate(DockerTemplateBase dockerTemplateBase, String labelString, String remoteFs, String remoteFsMapping, String instanceCapStr, Node.Mode mode, int numExecutors, DockerComputerLauncher launcher, RetentionStrategy retentionStrategy, boolean removeVolumes, DockerImagePullStrategy pullStrategy) {
        this(dockerTemplateBase, labelString, remoteFs, remoteFsMapping, instanceCapStr);
        this.setMode(mode);
        this.setNumExecutors(numExecutors);
        this.setLauncher(launcher);
        this.setRetentionStrategy(retentionStrategy);
        this.setRemoveVolumes(removeVolumes);
        this.setPullStrategy(pullStrategy);
    }

    public DockerTemplateBase getDockerTemplateBase() {
        return this.dockerTemplateBase;
    }

    @Override
    public void setDockerTemplateBase(DockerTemplateBase dockerTemplateBase) {
        this.dockerTemplateBase = dockerTemplateBase;
    }

    public boolean isRemoveVolumes() {
        return this.removeVolumes;
    }

    @DataBoundSetter
    public void setRemoveVolumes(boolean removeVolumes) {
        this.removeVolumes = removeVolumes;
    }

    public String getLabelString() {
        return this.labelString;
    }

    @DataBoundSetter
    public void setMode(Node.Mode mode) {
        this.mode = mode;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    @DataBoundSetter
    public void setNumExecutors(int numExecutors) {
        this.numExecutors = numExecutors;
    }

    public int getNumExecutors() {
        if (this.getRetentionStrategy() instanceof DockerOnceRetentionStrategy) {
            return 1;
        }
        return this.numExecutors;
    }

    @DataBoundSetter
    public void setRetentionStrategy(RetentionStrategy retentionStrategy) {
        this.retentionStrategy = retentionStrategy;
    }

    public RetentionStrategy getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public RetentionStrategy getRetentionStrategyCopy() {
        if (this.retentionStrategy instanceof DockerOnceRetentionStrategy) {
            DockerOnceRetentionStrategy onceRetention = (DockerOnceRetentionStrategy)this.retentionStrategy;
            return new DockerOnceRetentionStrategy(onceRetention.getIdleMinutes());
        }
        return this.retentionStrategy;
    }

    @Override
    @DataBoundSetter
    public void setLauncher(DockerComputerLauncher launcher) {
        this.launcher = launcher;
    }

    public DockerComputerLauncher getLauncher() {
        return this.launcher;
    }

    public String getRemoteFs() {
        return this.remoteFs;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public String getRemoteFsMapping() {
        return this.remoteFsMapping;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public DockerImagePullStrategy getPullStrategy() {
        return this.pullStrategy;
    }

    @DataBoundSetter
    public void setPullStrategy(DockerImagePullStrategy pullStrategy) {
        this.pullStrategy = pullStrategy;
    }

    public Object readResolve() {
        try {
            if (this.configVersion < 1) {
                this.convert1();
                this.configVersion = 1;
            }
            if (this.configVersion < 2) {
                DockerOnceRetentionStrategy tmpStrategy;
                if (this.retentionStrategy instanceof DockerOnceRetentionStrategy && (tmpStrategy = (DockerOnceRetentionStrategy)this.retentionStrategy).getIdleMinutes() == 0) {
                    this.setRetentionStrategy((RetentionStrategy)new DockerOnceRetentionStrategy(10));
                }
                this.configVersion = 2;
            } else {
                if (this.mode == null) {
                    this.mode = Node.Mode.NORMAL;
                }
                if (this.retentionStrategy == null) {
                    this.retentionStrategy = new DockerOnceRetentionStrategy(10);
                }
                if (this.pullStrategy == null) {
                    this.pullStrategy = DockerImagePullStrategy.PULL_LATEST;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Can't convert old values to new (double conversion?): ", t);
        }
        try {
            this.labelSet = Label.parse((String)this.labelString);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Can't parse labels: ", t);
        }
        return this;
    }

    public String toString() {
        return "DockerTemplate{configVersion=" + this.configVersion + ", labelString='" + this.labelString + '\'' + ", launcher=" + (Object)((Object)this.launcher) + ", remoteFsMapping='" + this.remoteFsMapping + '\'' + ", remoteFs='" + this.remoteFs + '\'' + ", instanceCap=" + this.instanceCap + ", mode=" + this.mode + ", retentionStrategy=" + this.retentionStrategy + ", numExecutors=" + this.numExecutors + ", dockerTemplateBase=" + this.dockerTemplateBase + ", removeVolumes=" + this.removeVolumes + ", pullStrategy=" + (Object)((Object)this.pullStrategy) + '}';
    }

    public String getShortDescription() {
        return MoreObjects.toStringHelper((Object)this).add("image", (Object)this.dockerTemplateBase.getImage()).toString();
    }

    public Descriptor<DockerTemplate> getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(this.getClass());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerTemplate> {
        public FormValidation doCheckNumExecutors(@QueryParameter int numExecutors) {
            if (numExecutors > 1) {
                return FormValidation.warning((String)"Experimental, see help");
            }
            if (numExecutors < 1) {
                return FormValidation.error((String)"Must be > 0");
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "Docker Template";
        }

        public Class getDockerTemplateBase() {
            return DockerTemplateBase.class;
        }
    }
}

