/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.NotModifiedException;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionDescriptor;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionStopStart;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderControlOptionStop
extends DockerBuilderControlOptionStopStart {
    private static final Logger LOG = LoggerFactory.getLogger(DockerBuilderControlOptionStop.class);
    public final boolean remove;

    @DataBoundConstructor
    public DockerBuilderControlOptionStop(String cloudName, String containerId, boolean remove) {
        super(cloudName, containerId);
        this.remove = remove;
    }

    @Override
    public void execute(Run<?, ?> build, Launcher launcher, TaskListener listener) throws DockerException {
        PrintStream llog = listener.getLogger();
        LOG.info("Stopping container " + this.containerId);
        llog.println("Stopping container " + this.containerId);
        DockerClient client = this.getCloud(build, launcher).getClient();
        try {
            client.stopContainerCmd(this.containerId).exec();
        }
        catch (NotModifiedException ex) {
            LOG.info("Already stopped.");
            llog.println("Already stopped.");
        }
        this.getLaunchAction(build).stopped(client, this.containerId);
        if (this.remove) {
            LOG.info("Removing container {}...", (Object)this.containerId);
            llog.println("Removing container " + this.containerId + "...");
            client.removeContainerCmd(this.containerId);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Stop Container";
        }
    }
}

