/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerException;
import com.nirima.jenkins.plugins.docker.action.DockerLaunchAction;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOption;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionDescriptor;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderControlOptionStopAll
extends DockerBuilderControlOption {
    private static final Logger LOG = LoggerFactory.getLogger(DockerBuilderControlOptionStopAll.class);
    public final boolean remove;

    @DataBoundConstructor
    public DockerBuilderControlOptionStopAll(boolean remove) {
        this.remove = remove;
    }

    @Override
    public void execute(Run<?, ?> build, Launcher launcher, TaskListener listener) throws DockerException {
        PrintStream llog = listener.getLogger();
        LOG.info("Stopping all containers");
        llog.println("Stopping all containers");
        for (DockerLaunchAction.Item containerItem : this.getLaunchAction(build).getRunning()) {
            LOG.info("Stopping container {}", (Object)containerItem.id);
            llog.println("Stopping container " + containerItem.id);
            containerItem.client.stopContainerCmd(containerItem.id).exec();
            if (!this.remove) continue;
            LOG.info("Removing container {}", (Object)containerItem.id);
            llog.println("Removing container " + containerItem.id);
            containerItem.client.removeContainerCmd(containerItem.id).exec();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Stop All Containers";
        }
    }
}

