/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerClientException;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.action.DockerBuildImageAction;
import com.nirima.jenkins.plugins.docker.client.ClientBuilderForPlugin;
import com.nirima.jenkins.plugins.docker.client.ClientConfigBuilderForPlugin;
import com.nirima.jenkins.plugins.docker.client.DockerCmdExecConfig;
import com.nirima.jenkins.plugins.docker.client.DockerCmdExecConfigBuilderForPlugin;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import com.nirima.jenkins.plugins.docker.utils.LogUtils;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.base.Joiner;
import shaded.com.google.common.base.Optional;
import shaded.com.google.common.base.Splitter;
import shaded.com.google.common.base.Strings;

public class DockerBuilderPublisher
extends Builder
implements Serializable,
SimpleBuildStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerBuilderPublisher.class);
    private static final Pattern VALID_REPO_PATTERN = Pattern.compile("^([a-z0-9-_.]+)$");
    public final String dockerFileDirectory;
    @Deprecated
    public String tag;
    @CheckForNull
    private List<String> tags;
    public final boolean pushOnSuccess;
    public final boolean cleanImages;
    public final boolean cleanupWithJenkinsJobDelete;
    public final String cloud;

    @DataBoundConstructor
    public DockerBuilderPublisher(String dockerFileDirectory, String cloud, String tagsString, boolean pushOnSuccess, boolean cleanImages, boolean cleanupWithJenkinsJobDelete) {
        this.dockerFileDirectory = dockerFileDirectory;
        this.setTagsString(tagsString);
        this.tag = null;
        this.cloud = cloud;
        this.pushOnSuccess = pushOnSuccess;
        this.cleanImages = cleanImages;
        this.cleanupWithJenkinsJobDelete = cleanupWithJenkinsJobDelete;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getTagsString() {
        return this.getTags() == null ? "" : Joiner.on((String)"\n").join(this.getTags());
    }

    public void setTagsString(String tagsString) {
        this.setTags(DockerBuilderPublisher.filterStringToList(tagsString));
    }

    public static List<String> filterStringToList(String str) {
        return str == null ? Collections.emptyList() : Splitter.on((String)"\n").omitEmptyStrings().trimResults().splitToList((CharSequence)str);
    }

    public static void verifyTags(String tagsString) {
        List<String> verifyTags = DockerBuilderPublisher.filterStringToList(tagsString);
        for (String verifyTag : verifyTags) {
            if (VALID_REPO_PATTERN.matcher(verifyTag).matches()) continue;
            throw new IllegalArgumentException("Tag " + verifyTag + " doesn't match ^([a-z0-9-_.]+)$");
        }
    }

    protected DockerCloud getCloud(Launcher launcher) {
        DockerCloud theCloud;
        if (!Strings.isNullOrEmpty((String)this.cloud)) {
            theCloud = JenkinsUtils.getServer(this.cloud);
        } else {
            Optional<DockerCloud> cloud = JenkinsUtils.getCloudForChannel(launcher.getChannel());
            if (!cloud.isPresent()) {
                throw new RuntimeException("Could not find the cloud this project was built on");
            }
            theCloud = (DockerCloud)((Object)cloud.get());
        }
        if (theCloud.isTriton()) {
            LOGGER.warn("Selected cloud for build does not support this feature. Finding an alternative");
            for (DockerCloud dc : JenkinsUtils.getServers()) {
                if (dc.isTriton()) continue;
                LOGGER.warn("Picked {} cloud instead", (Object)dc.getDisplayName());
                return dc;
            }
        }
        return theCloud;
    }

    public void perform(hudson.model.Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        List<String> expandedTags = run instanceof AbstractBuild ? this.expandTags((AbstractBuild)run, launcher, listener) : this.tags;
        new Run(run, launcher, listener, new FilePath(workspace, this.dockerFileDirectory), expandedTags, this.getCloud(launcher)).run();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private List<String> expandTags(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) {
        ArrayList<String> eTags = new ArrayList<String>(this.tags.size());
        for (String tag : this.tags) {
            try {
                eTags.add(TokenMacro.expandAll(build, (TaskListener)listener, (String)tag));
            }
            catch (IOException | InterruptedException | MacroEvaluationException e) {
                listener.getLogger().println("Couldn't macro expand tag " + tag);
            }
        }
        return eTags;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckTagsString(@QueryParameter String tagsString) {
            try {
                DockerBuilderPublisher.verifyTags(tagsString);
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Build / Publish Docker Containers";
        }
    }

    class Run
    implements Serializable {
        final transient Launcher launcher;
        final TaskListener listener;
        final FilePath fpChild;
        final List<String> tagsToUse;
        private transient DockerClient _client;
        final DockerClientConfig clientConfig;
        final DockerCmdExecConfig dockerCmdExecConfig;
        final transient hudson.model.Run<?, ?> run;
        final String url;

        private Run(hudson.model.Run<?, ?> run, Launcher launcher, TaskListener listener, FilePath fpChild, List<String> tagsToUse, DockerCloud dockerCloud) {
            this.run = run;
            this.launcher = launcher;
            this.listener = listener;
            this.fpChild = fpChild;
            this.tagsToUse = tagsToUse;
            this.clientConfig = ClientConfigBuilderForPlugin.dockerClientConfig().forCloud(dockerCloud).build();
            this.dockerCmdExecConfig = DockerCmdExecConfigBuilderForPlugin.builder().forCloud(dockerCloud).build();
            this.url = dockerCloud.serverUrl;
        }

        private DockerClient getClient() {
            if (this._client == null) {
                Validate.notNull((Object)this.clientConfig, (String)"Could not get client because we could not find the cloud that the project was built on. What this build run on Docker?");
                this._client = ClientBuilderForPlugin.builder().withDockerCmdExecConfig(this.dockerCmdExecConfig).withDockerClientConfig(this.clientConfig).build();
            }
            return this._client;
        }

        boolean run() throws IOException, InterruptedException {
            PrintStream llog = this.listener.getLogger();
            llog.println("Docker Build");
            String imageId = this.buildImage();
            if (imageId == null) {
                return false;
            }
            llog.println("Docker Build Response : " + imageId);
            this.run.addAction((Action)new DockerBuildImageAction(this.url, imageId, this.tagsToUse, DockerBuilderPublisher.this.cleanupWithJenkinsJobDelete, DockerBuilderPublisher.this.pushOnSuccess));
            this.run.save();
            if (DockerBuilderPublisher.this.pushOnSuccess) {
                llog.println("Pushing " + this.tagsToUse);
                this.pushImages();
            }
            if (DockerBuilderPublisher.this.cleanImages) {
                llog.println("Cleaning local images [" + imageId + "]");
                try {
                    this.cleanImages(imageId);
                }
                catch (Exception ex) {
                    llog.println("Error attempting to clean images");
                }
            }
            llog.println("Docker Build Done");
            return true;
        }

        private void cleanImages(String id) {
            this.getClient().removeImageCmd(id).withForce().exec();
        }

        private String buildImage() throws IOException, InterruptedException {
            return (String)this.fpChild.act((FilePath.FileCallable)new MasterToSlaveFileCallable<String>(){

                public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                    Run.this.log("Docker Build: building image at path " + f.getAbsolutePath());
                    BuildImageResultCallback resultCallback = new BuildImageResultCallback(){

                        public void onNext(BuildResponseItem item) {
                            String text = item.getStream();
                            if (text != null) {
                                Run.this.log(text);
                            }
                            super.onNext(item);
                        }
                    };
                    String imageId = ((BuildImageResultCallback)Run.this.getClient().buildImageCmd(f).exec((ResultCallback)resultCallback)).awaitImageId();
                    if (imageId == null) {
                        throw new AbortException("Built image id is null. Some error accured");
                    }
                    for (String tag : Run.this.tagsToUse) {
                        NameParser.ReposTag reposTag = NameParser.parseRepositoryTag((String)tag);
                        String commitTag = StringUtils.isEmpty((String)reposTag.tag) ? "latest" : reposTag.tag;
                        Run.this.log("Tagging built image with " + reposTag.repos + ":" + commitTag);
                        Run.this.getClient().tagImageCmd(imageId, reposTag.repos, commitTag).withForce().exec();
                    }
                    return imageId;
                }
            });
        }

        protected void log(String s) {
            PrintStream llog = this.listener.getLogger();
            llog.println(s);
        }

        private void pushImages() {
            for (String tagToUse : this.tagsToUse) {
                Identifier identifier = Identifier.fromCompoundString((String)tagToUse);
                PushImageResultCallback resultCallback = new PushImageResultCallback(){

                    public void onNext(PushResponseItem item) {
                        if (item == null) {
                            Run.this.log("Received NULL Push Response. Ignoring");
                            return;
                        }
                        LogUtils.printResponseItemToListener(Run.this.listener, (ResponseItem)item);
                        super.onNext(item);
                    }
                };
                try {
                    PushImageCmd cmd = this.getClient().pushImageCmd(identifier);
                    AuthConfig authConfig = JenkinsUtils.getAuthConfigFor(tagToUse);
                    if (authConfig != null) {
                        cmd.withAuthConfig(authConfig);
                    }
                    ((PushImageResultCallback)cmd.exec((ResultCallback)resultCallback)).awaitSuccess();
                }
                catch (DockerClientException ex) {
                    this.log("Exception pushing docker image. Check that the destination registry is running.");
                    throw ex;
                }
            }
        }
    }
}

