/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.client;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.KeystoreSSLConfig;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.SSLConfig;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.client.ClientBuilderForPlugin;
import com.nirima.jenkins.plugins.docker.utils.DockerDirectoryCredentials;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.net.URI;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;

public class ClientConfigBuilderForPlugin {
    private static final Logger LOGGER = Logger.getLogger(ClientConfigBuilderForPlugin.class.getName());
    private DockerClientConfig.DockerClientConfigBuilder config = DockerClientConfig.createDefaultConfigBuilder();

    private ClientConfigBuilderForPlugin() {
    }

    public static ClientConfigBuilderForPlugin dockerClientConfig() {
        return new ClientConfigBuilderForPlugin();
    }

    public ClientConfigBuilderForPlugin forCloud(DockerCloud cloud) {
        LOGGER.log(Level.FINE, "Building connection to docker host \"{0}\" at: {1}", new Object[]{cloud.getDisplayName(), cloud.serverUrl});
        this.forServer(cloud.serverUrl, cloud.version);
        return this.withCredentials(cloud.credentialsId);
    }

    public ClientConfigBuilderForPlugin forServer(String uri, @Nullable String version) {
        this.config.withUri(URI.create(uri).toString()).withVersion(version);
        return this;
    }

    public ClientConfigBuilderForPlugin withCredentials(String credentialsId) {
        if (StringUtils.isNotBlank((String)credentialsId)) {
            Credentials credentials = ClientConfigBuilderForPlugin.lookupSystemCredentials(credentialsId);
            if (credentials instanceof CertificateCredentials) {
                CertificateCredentials certificateCredentials = (CertificateCredentials)credentials;
                this.config.withSSLConfig((SSLConfig)new KeystoreSSLConfig(certificateCredentials.getKeyStore(), certificateCredentials.getPassword().getPlainText()));
            } else if (credentials instanceof DockerDirectoryCredentials) {
                DockerDirectoryCredentials ddc = (DockerDirectoryCredentials)credentials;
                this.config.withSSLConfig((SSLConfig)new LocalDirectorySSLConfig(ddc.getPath()));
            } else if (credentials instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials usernamePasswordCredentials = (StandardUsernamePasswordCredentials)credentials;
                this.config.withUsername(usernamePasswordCredentials.getUsername());
                this.config.withPassword(usernamePasswordCredentials.getPassword().getPlainText());
            }
        }
        return this;
    }

    public DockerClientConfig build() {
        return this.config.build();
    }

    public DockerClient buildClient() {
        return ClientBuilderForPlugin.builder().withDockerClientConfig(this.build()).build();
    }

    DockerClientConfig.DockerClientConfigBuilder config() {
        return this.config;
    }

    private static Credentials lookupSystemCredentials(String credentialsId) {
        return CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(Credentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }
}

