/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.launcher;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import shaded.com.google.common.annotations.Beta;

@Beta
public abstract class DockerComputerLauncher
extends ComputerLauncher {
    protected ComputerLauncher launcher;

    public abstract ComputerLauncher getPreparedLauncher(String var1, DockerTemplate var2, InspectContainerResponse var3);

    public abstract void appendContainerConfig(DockerTemplate var1, CreateContainerCmd var2) throws IOException;

    public boolean waitUp(String cloudId, DockerTemplate dockerTemplate, InspectContainerResponse containerInspect) {
        if (!containerInspect.getState().isRunning()) {
            throw new IllegalStateException("Container '" + containerInspect.getId() + "' is not running!");
        }
        return true;
    }

    public ComputerLauncher getLauncher() {
        if (this.launcher == null) {
            throw new IllegalStateException("Launcher must not be null");
        }
        return this.launcher;
    }

    public void setLauncher(ComputerLauncher launcher) {
        this.launcher = launcher;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        this.getLauncher().launch(computer, listener);
    }

    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        this.getLauncher().afterDisconnect(computer, listener);
    }

    public void beforeDisconnect(SlaveComputer computer, TaskListener listener) {
        this.getLauncher().beforeDisconnect(computer, listener);
    }
}

