/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.launcher;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerLauncher;
import com.nirima.jenkins.plugins.docker.utils.PortUtils;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.plugins.sshslaves.SSHConnector;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.util.ListBoxModel;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import shaded.com.google.common.annotations.Beta;
import shaded.com.google.common.base.Preconditions;

@Beta
public class DockerComputerSSHLauncher
extends DockerComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(DockerComputerSSHLauncher.class.getName());
    protected final SSHConnector sshConnector;
    @Restricted(value={NoExternalUse.class})
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public DockerComputerSSHLauncher(SSHConnector sshConnector) {
        this.sshConnector = sshConnector;
    }

    public SSHConnector getSshConnector() {
        return this.sshConnector;
    }

    @Override
    public ComputerLauncher getPreparedLauncher(String cloudId, DockerTemplate dockerTemplate, InspectContainerResponse inspect) {
        DockerComputerSSHLauncher prepLauncher = new DockerComputerSSHLauncher(null);
        prepLauncher.setLauncher((ComputerLauncher)this.getSSHLauncher(cloudId, dockerTemplate, inspect));
        return prepLauncher;
    }

    @Override
    public void appendContainerConfig(DockerTemplate dockerTemplate, CreateContainerCmd createCmd) {
        int sshPort = this.getSshConnector().port;
        createCmd.withExposedPorts(new ExposedPort[]{new ExposedPort(this.sshConnector.port)});
        String[] cmd = dockerTemplate.getDockerTemplateBase().getDockerCommandArray();
        if (cmd.length == 0) {
            createCmd.withCmd(new String[]{"bash", "-c", "/usr/sbin/sshd -D -p " + sshPort});
        }
        createCmd.getPortBindings().add(new PortBinding[]{PortBinding.parse((String)("0.0.0.0::" + sshPort))});
    }

    @Override
    public boolean waitUp(String cloudId, DockerTemplate dockerTemplate, InspectContainerResponse containerInspect) {
        super.waitUp(cloudId, dockerTemplate, containerInspect);
        PortUtils.ConnectionCheck connectionCheck = PortUtils.connectionCheck(this.getAddressForSSHD(cloudId, containerInspect)).withRetries(60).withEveryRetryWaitFor(2, TimeUnit.SECONDS);
        return connectionCheck.execute() && connectionCheck.useSSH().execute();
    }

    private SSHLauncher getSSHLauncher(String cloudId, DockerTemplate template, InspectContainerResponse inspect) {
        Preconditions.checkNotNull((Object)template);
        Preconditions.checkNotNull((Object)inspect);
        try {
            InetSocketAddress address = this.getAddressForSSHD(cloudId, inspect);
            LOGGER.log(Level.INFO, "Creating slave SSH launcher for " + address);
            return new SSHLauncher(address.getHostString(), address.getPort(), this.sshConnector.getCredentials(), this.sshConnector.jvmOptions, this.sshConnector.javaPath, this.sshConnector.prefixStartSlaveCmd, this.sshConnector.suffixStartSlaveCmd, this.sshConnector.launchTimeoutSeconds);
        }
        catch (NullPointerException ex) {
            throw new RuntimeException("No mapped port 22 in host for SSL. Config=" + inspect, ex);
        }
    }

    protected InetSocketAddress getAddressForSSHD(String cloudId, InspectContainerResponse ir) {
        Ports.Binding[] sshBindings;
        ExposedPort sshPort = new ExposedPort(this.sshConnector.port);
        String host = null;
        Integer port = 22;
        InspectContainerResponse.NetworkSettings networkSettings = ir.getNetworkSettings();
        Ports ports = networkSettings.getPorts();
        Map bindings = ports.getBindings();
        for (Ports.Binding b : sshBindings = (Ports.Binding[])bindings.get(sshPort)) {
            port = b.getHostPort();
            host = b.getHostIp();
        }
        if ((host == null || host.equals("0.0.0.0")) && ((host = URI.create(DockerCloud.getCloudByName((String)cloudId).serverUrl).getHost()) == null || host.equals("0.0.0.0") || DockerComputerSSHLauncher.usesSingleHostAbstraction(ir))) {
            host = networkSettings.getIpAddress();
            port = this.sshConnector.port;
        }
        return new InetSocketAddress(host, (int)port);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        return DESCRIPTOR;
    }

    protected static boolean usesSingleHostAbstraction(InspectContainerResponse inspect) {
        Preconditions.checkNotNull((Object)inspect);
        return inspect.getDriver().equals("sdc");
    }

    public static final class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            return DockerTemplateBase.DescriptorImpl.doFillCredentialsIdItems(context);
        }

        public Class getSshConnectorClass() {
            return SSHConnector.class;
        }

        public String getDisplayName() {
            return "Docker SSH computer launcher";
        }
    }
}

