/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.utils;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.core.NameParser;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerPluginConfiguration;
import com.nirima.jenkins.plugins.docker.DockerRegistry;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import hudson.model.Run;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.Cloud;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import shaded.com.google.common.base.Optional;
import shaded.com.google.common.base.Predicate;
import shaded.com.google.common.collect.Collections2;
import shaded.com.google.common.collect.Iterables;

public class JenkinsUtils {
    public static Optional<DockerCloud> getCloudForBuild(AbstractBuild build) {
        Node node = build.getBuiltOn();
        if (node instanceof DockerSlave) {
            DockerSlave slave = (DockerSlave)node;
            return Optional.of((Object)((Object)slave.getCloud()));
        }
        return Optional.absent();
    }

    public static Optional<DockerCloud> getCloudForChannel(VirtualChannel channel) {
        if (channel instanceof Channel) {
            Channel c = (Channel)channel;
            Node node = Jenkins.getInstance().getNode(c.getName());
            if (node instanceof DockerSlave) {
                DockerSlave slave = (DockerSlave)node;
                return Optional.of((Object)((Object)slave.getCloud()));
            }
        }
        return Optional.absent();
    }

    public static Optional<DockerCloud> getCloudThatWeBuiltOn(Run<?, ?> build, Launcher launcher) {
        Optional<DockerCloud> cloud = build instanceof AbstractBuild ? JenkinsUtils.getCloudForBuild((AbstractBuild)build) : JenkinsUtils.getCloudForChannel(launcher.getChannel());
        return cloud;
    }

    public static synchronized Collection<DockerCloud> getServers() {
        Collection clouds = Collections2.filter((Collection)Jenkins.getInstance().clouds, (Predicate)new Predicate<Cloud>(){

            public boolean apply(@Nullable Cloud input) {
                return input instanceof DockerCloud;
            }
        });
        return clouds;
    }

    public static DockerCloud getServer(final String serverName) {
        return (DockerCloud)((Object)Iterables.find(JenkinsUtils.getServers(), (Predicate)new Predicate<DockerCloud>(){

            public boolean apply(@Nullable DockerCloud input) {
                return serverName.equals(input.getDisplayName());
            }
        }));
    }

    public static String getHostnameFromBinding(InspectContainerResponse inspectContainerResponse) {
        Ports.Binding[] binding;
        Map bindings = inspectContainerResponse.getHostConfig().getPortBindings().getBindings();
        if (bindings != null && !bindings.isEmpty() && (binding = (Ports.Binding[])bindings.values().iterator().next()) != null && binding.length > 0) {
            String hostIp = binding[0].getHostIp();
            return JenkinsUtils.getHostnameForIp(hostIp);
        }
        return null;
    }

    private static String getHostnameForIp(String hospIp) {
        try {
            return InetAddress.getByName(hospIp).getHostName();
        }
        catch (UnknownHostException e) {
            return hospIp;
        }
    }

    public static AuthConfig getAuthConfigFor(String imageName) {
        NameParser.ReposTag reposTag = NameParser.parseRepositoryTag((String)imageName);
        NameParser.HostnameReposName hostnameReposName = NameParser.resolveRepositoryName((String)reposTag.repos);
        DockerRegistry registry = DockerPluginConfiguration.get().getRegistryByName(hostnameReposName.hostname);
        if (registry == null) {
            return null;
        }
        StandardUsernameCredentials credentials = SSHLauncher.lookupSystemCredentials((String)registry.credentialsId);
        if (credentials instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials usernamePasswordCredentials = (StandardUsernamePasswordCredentials)credentials;
            AuthConfig ac = new AuthConfig();
            ac.setUsername(usernamePasswordCredentials.getUsername());
            ac.setPassword(usernamePasswordCredentials.getPassword().getPlainText());
            return ac;
        }
        return null;
    }
}

