/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerComputer;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildVariableContributor;
import hudson.model.Executor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DockerBuildVariableContributor
extends BuildVariableContributor {
    private static final Logger LOG = LoggerFactory.getLogger(DockerBuildVariableContributor.class);

    public void buildVariablesFor(AbstractBuild build, Map<String, String> variables) {
        Executor executor = build.getExecutor();
        if (executor != null && executor.getOwner() instanceof DockerComputer) {
            DockerComputer dockerComputer = (DockerComputer)executor.getOwner();
            variables.put("DOCKER_CONTAINER_ID", dockerComputer.getContainerId());
            variables.put("JENKINS_CLOUD_ID", dockerComputer.getCloudId());
            DockerCloud cloud = dockerComputer.getCloud();
            if (cloud.isExposeDockerHost()) {
                String dockerHost = cloud.getServerUrl();
                if (dockerHost.startsWith("unix:")) {
                    dockerHost = "tcp:" + dockerHost.substring(5);
                }
                variables.put("DOCKER_HOST", dockerHost);
            }
        }
    }
}

