/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.nirima.jenkins.plugins.docker.DockerImagePullStrategy;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.client.ClientBuilderForPlugin;
import com.nirima.jenkins.plugins.docker.client.ClientConfigBuilderForPlugin;
import com.nirima.jenkins.plugins.docker.client.DockerCmdExecConfig;
import com.nirima.jenkins.plugins.docker.client.DockerCmdExecConfigBuilderForPlugin;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerLauncher;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.docker.DockerSlaveProvisioner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryToken;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCloud
extends Cloud {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerCloud.class);
    private List<DockerTemplate> templates;
    private transient HashMap<Long, DockerTemplate> jobTemplates;
    private DockerServerEndpoint dockerHost;
    @Deprecated
    private transient String serverUrl;
    @Deprecated
    public transient String credentialsId;
    private int connectTimeout;
    public final int readTimeout;
    public final String version;
    public final String dockerHostname;
    private transient DockerClient connection;
    private int containerCap = 100;
    private transient Boolean _isSwarm;
    private transient Boolean _isTriton;
    private static final HashMap<String, Integer> provisionedImages = new HashMap();
    private Boolean exposeDockerHost;

    @DataBoundConstructor
    public DockerCloud(String name, List<? extends DockerTemplate> templates, DockerServerEndpoint dockerHost, int containerCap, int connectTimeout, int readTimeout, String version, String dockerHostname) {
        super(name);
        this.version = version;
        this.dockerHost = dockerHost;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.dockerHostname = dockerHostname;
        this.templates = templates != null ? new ArrayList<DockerTemplate>(templates) : Collections.emptyList();
        this.setContainerCap(containerCap);
    }

    @Deprecated
    public DockerCloud(String name, List<? extends DockerTemplate> templates, String serverUrl, int containerCap, int connectTimeout, int readTimeout, String credentialsId, String version, String dockerHostname) {
        this(name, templates, new DockerServerEndpoint(serverUrl, credentialsId), containerCap, connectTimeout, readTimeout, version, dockerHostname);
    }

    @Deprecated
    public DockerCloud(String name, List<? extends DockerTemplate> templates, String serverUrl, String containerCapStr, int connectTimeout, int readTimeout, String credentialsId, String version, String dockerHostname) {
        this(name, templates, serverUrl, containerCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(containerCapStr), connectTimeout, readTimeout, credentialsId, version, dockerHostname);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public DockerServerEndpoint getDockerHost() {
        return this.dockerHost;
    }

    @Deprecated
    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getDockerHostname() {
        return this.dockerHostname;
    }

    @Deprecated
    public String getContainerCapStr() {
        if (this.containerCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.containerCap);
    }

    public int getContainerCap() {
        return this.containerCap;
    }

    public void setContainerCap(int containerCap) {
        this.containerCap = containerCap;
    }

    protected String sanitizeUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replace("http:", "tcp:").replace("https:", "tcp:");
    }

    public synchronized DockerClient getClient() {
        if (this.connection == null) {
            DockerClientConfig clientConfig = ClientConfigBuilderForPlugin.dockerClientConfig().forCloud(this).build();
            DockerCmdExecConfig execConfig = DockerCmdExecConfigBuilderForPlugin.builder().forCloud(this).build();
            this.connection = ClientBuilderForPlugin.builder().withDockerClientConfig(clientConfig).withDockerCmdExecConfig(execConfig).build();
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementAmiSlaveProvision(String ami) {
        HashMap<String, Integer> hashMap = provisionedImages;
        synchronized (hashMap) {
            int currentProvisioning;
            try {
                currentProvisioning = provisionedImages.get(ami);
            }
            catch (NullPointerException npe) {
                return;
            }
            provisionedImages.put(ami, Math.max(currentProvisioning - 1, 0));
        }
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        try {
            LOGGER.info("Asked to provision {} slave(s) for: {}", new Object[]{excessWorkload, label});
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            List<DockerTemplate> templates = this.getTemplates(label);
            while (excessWorkload > 0 && !templates.isEmpty()) {
                DockerTemplate t;
                block6: {
                    t = templates.get(0);
                    LOGGER.info("Will provision '{}', for label: '{}', in cloud: '{}'", new Object[]{t.getDockerTemplateBase().getImage(), label, this.getDisplayName()});
                    try {
                        if (!this.addProvisionedSlave(t)) {
                            templates.remove(t);
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Bad template '{}' in cloud '{}': '{}'. Trying next template...", new Object[]{t.getDockerTemplateBase().getImage(), this.getDisplayName(), e.getMessage(), e});
                        templates.remove(t);
                    }
                    continue;
                }
                r.add(new NodeProvisioner.PlannedNode(t.getDockerTemplateBase().getDisplayName(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                    @Override
                    public Node call() throws Exception {
                        try {
                            DockerSlave dockerSlave = DockerCloud.this.provisionWithWait(t);
                            return dockerSlave;
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error in provisioning; template='{}' for cloud='{}'", new Object[]{t, DockerCloud.this.getDisplayName(), ex});
                            throw Throwables.propagate((Throwable)ex);
                        }
                        finally {
                            DockerCloud.this.decrementAmiSlaveProvision(t.getDockerTemplateBase().getImage());
                        }
                    }
                }), t.getNumExecutors()));
                excessWorkload -= t.getNumExecutors();
            }
            return r;
        }
        catch (Exception e) {
            LOGGER.error("Exception while provisioning for label: '{}', cloud='{}'", new Object[]{label, this.getDisplayName(), e});
            return Collections.emptyList();
        }
    }

    public static String runContainer(DockerTemplateBase dockerTemplateBase, DockerClient dockerClient, DockerComputerLauncher launcher) {
        CreateContainerCmd containerConfig = dockerClient.createContainerCmd(dockerTemplateBase.getImage());
        dockerTemplateBase.fillContainerConfig(containerConfig);
        CreateContainerResponse response = containerConfig.exec();
        String containerId = response.getId();
        StartContainerCmd startCommand = dockerClient.startContainerCmd(containerId);
        startCommand.exec();
        return containerId;
    }

    protected boolean shouldPullImage(String imageName, DockerImagePullStrategy pullStrategy) {
        NameParser.ReposTag repostag = NameParser.parseRepositoryTag((String)imageName);
        final String fullImageName = repostag.repos + ":" + (repostag.tag.isEmpty() ? "latest" : repostag.tag);
        if (pullStrategy.pullIfExists(fullImageName) && pullStrategy.pullIfNotExists(fullImageName)) {
            return true;
        }
        if (!pullStrategy.pullIfExists(fullImageName) && !pullStrategy.pullIfNotExists(fullImageName)) {
            return false;
        }
        List images = (List)this.getClient().listImagesCmd().exec();
        boolean imageExists = Iterables.any((Iterable)images, (Predicate)new Predicate<Image>(){

            public boolean apply(Image image) {
                if (image == null || image.getRepoTags() == null) {
                    return false;
                }
                return Arrays.asList(image.getRepoTags()).contains(fullImageName);
            }
        });
        return imageExists ? pullStrategy.pullIfExists(fullImageName) : pullStrategy.pullIfNotExists(fullImageName);
    }

    private void pullImage(DockerTemplate dockerTemplate) throws IOException {
        String imageName = dockerTemplate.getDockerTemplateBase().getImage();
        if (this.shouldPullImage(imageName, dockerTemplate.getPullStrategy())) {
            LOGGER.info("Pulling image '{}'. This may take awhile...", (Object)imageName);
            long startTime = System.currentTimeMillis();
            PullImageCmd imgCmd = this.getClient().pullImageCmd(imageName);
            DockerRegistryEndpoint registry = dockerTemplate.getRegistry();
            if (registry == null) {
                DockerRegistryToken token = registry.getToken(null);
                AuthConfig auth = new AuthConfig().withRegistryAddress(registry.getUrl()).withEmail(token.getEmail()).withRegistrytoken(token.getToken());
                imgCmd.withAuthConfig(auth);
            }
            ((PullImageResultCallback)imgCmd.exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
            long pullTime = System.currentTimeMillis() - startTime;
            LOGGER.info("Finished pulling image '{}', took {} ms", (Object)imageName, (Object)pullTime);
        }
    }

    private DockerSlave provisionWithWait(DockerTemplate template) throws IOException, Descriptor.FormException, InterruptedException {
        DockerSlaveProvisioner provisioner = template.getProvisioner(this);
        return provisioner.provision();
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    @CheckForNull
    public DockerTemplate getTemplate(String template) {
        for (DockerTemplate t : this.templates) {
            if (!t.getImage().equals(template)) continue;
            return t;
        }
        return null;
    }

    @CheckForNull
    public DockerTemplate getTemplate(Label label) {
        List<DockerTemplate> templates = this.getTemplates(label);
        if (!templates.isEmpty()) {
            return templates.get(0);
        }
        return null;
    }

    public synchronized void addTemplate(DockerTemplate t) {
        this.templates.add(t);
    }

    public synchronized void addJobTemplate(long jobId, DockerTemplate template) {
        this.jobTemplates.put(jobId, template);
    }

    public synchronized void removeJobTemplate(long jobId) {
        if (this.jobTemplates.remove(jobId) == null) {
            LOGGER.warn("Couldn't remove template for job with id: {}", (Object)jobId);
        }
    }

    public List<DockerTemplate> getTemplates() {
        ArrayList<DockerTemplate> t = new ArrayList<DockerTemplate>(this.templates);
        t.addAll(this.getJobTemplates().values());
        return t;
    }

    public List<DockerTemplate> getTemplates(Label label) {
        ArrayList<DockerTemplate> dockerTemplates = new ArrayList<DockerTemplate>();
        for (DockerTemplate t : this.templates) {
            if (label == null && t.getMode() == Node.Mode.NORMAL) {
                dockerTemplates.add(t);
            }
            if (label == null || !label.matches(t.getLabelSet())) continue;
            dockerTemplates.add(t);
        }
        for (DockerTemplate template : this.getJobTemplates().values()) {
            if (label == null || !label.matches(template.getLabelSet())) continue;
            dockerTemplates.add(template);
        }
        return dockerTemplates;
    }

    private HashMap<Long, DockerTemplate> getJobTemplates() {
        if (this.jobTemplates == null) {
            this.jobTemplates = new HashMap();
        }
        return this.jobTemplates;
    }

    public synchronized void removeTemplate(DockerTemplate t) {
        this.templates.remove(t);
    }

    public int countCurrentDockerSlaves(String imageName) throws Exception {
        int count = 0;
        List containers = (List)this.getClient().listContainersCmd().exec();
        if (imageName == null) {
            count = containers.size();
        } else {
            for (Container container : containers) {
                String containerImage = container.getImage();
                if (!containerImage.equals(imageName)) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean addProvisionedSlave(DockerTemplate t) throws Exception {
        String ami = t.getDockerTemplateBase().getImage();
        int amiCap = t.instanceCap;
        int estimatedTotalSlaves = this.countCurrentDockerSlaves(null);
        int estimatedAmiSlaves = this.countCurrentDockerSlaves(ami);
        HashMap<String, Integer> hashMap = provisionedImages;
        synchronized (hashMap) {
            int currentProvisioning = 0;
            if (provisionedImages.containsKey(ami)) {
                currentProvisioning = provisionedImages.get(ami);
            }
            for (int amiCount : provisionedImages.values()) {
                estimatedTotalSlaves += amiCount;
            }
            estimatedAmiSlaves += currentProvisioning;
            if (estimatedTotalSlaves >= this.getContainerCap()) {
                LOGGER.info("Not Provisioning '{}'; Server '{}' full with '{}' container(s)", new Object[]{ami, this.name, this.getContainerCap()});
                return false;
            }
            if (amiCap != 0 && estimatedAmiSlaves >= amiCap) {
                LOGGER.info("Not Provisioning '{}'. Instance limit of '{}' reached on server '{}'", new Object[]{ami, amiCap, this.name});
                return false;
            }
            LOGGER.info("Provisioning '{}' number '{}' on '{}'; Total containers: '{}'", new Object[]{ami, estimatedAmiSlaves, this.name, estimatedTotalSlaves});
            provisionedImages.put(ami, currentProvisioning + 1);
            return true;
        }
    }

    public static DockerCloud getCloudByName(String name) {
        return (DockerCloud)Jenkins.getInstance().getCloud(name);
    }

    public Object readResolve() {
        for (DockerTemplate template : this.getTemplates()) {
            template.readResolve();
        }
        if (this.dockerHost == null) {
            this.serverUrl = this.sanitizeUrl(this.serverUrl);
            this.dockerHost = new DockerServerEndpoint(this.serverUrl, this.credentialsId);
        }
        return this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("name", (Object)this.name).add("serverUrl", (Object)this.serverUrl).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DockerCloud that = (DockerCloud)((Object)o);
        if (this.containerCap != that.containerCap) {
            return false;
        }
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        if (this.readTimeout != that.readTimeout) {
            return false;
        }
        if (this.templates != null ? !this.templates.equals(that.templates) : that.templates != null) {
            return false;
        }
        if (!this.dockerHost.equals((Object)that.dockerHost)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    boolean isSwarm() {
        Version remoteVersion = (Version)this.getClient().versionCmd().exec();
        if (this._isSwarm == null) {
            this._isSwarm = remoteVersion.getVersion().startsWith("swarm");
        }
        return this._isSwarm;
    }

    public boolean isTriton() {
        Version remoteVersion = (Version)this.getClient().versionCmd().exec();
        if (this._isTriton == null) {
            this._isTriton = remoteVersion.getOperatingSystem().equals("solaris");
        }
        return this._isTriton;
    }

    public boolean isExposeDockerHost() {
        return this.exposeDockerHost != null ? this.exposeDockerHost : true;
    }

    @DataBoundSetter
    public void setExposeDockerHost(boolean exposeDockerHost) {
        this.exposeDockerHost = exposeDockerHost;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Docker";
        }

        public FormValidation doTestConnection(@QueryParameter String uri, @QueryParameter String credentialsId, @QueryParameter String version, @QueryParameter Integer readTimeout, @QueryParameter Integer connectTimeout) throws IOException, ServletException, DockerException {
            try {
                DockerClientConfig clientConfig = ClientConfigBuilderForPlugin.dockerClientConfig().forServer(uri, version).withCredentials(credentialsId).build();
                DockerCmdExecConfig execConfig = DockerCmdExecConfigBuilderForPlugin.builder().withReadTimeout(readTimeout).withConnectTimeout(connectTimeout).build();
                DockerClient dc = ClientBuilderForPlugin.builder().withDockerClientConfig(clientConfig).withDockerCmdExecConfig(execConfig).build();
                Version verResult = (Version)dc.versionCmd().exec();
                return FormValidation.ok((String)("Version = " + verResult.getVersion() + ", API Version = " + verResult.getApiVersion()));
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)e.getMessage());
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            Jenkins ac;
            Object object = ac = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance();
            if (!ac.hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            List credentials = CredentialsProvider.lookupCredentials(DockerServerCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, Collections.emptyList());
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.always(), (Iterable)credentials);
        }
    }
}

