/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public class DockerJobTemplateProperty
implements Describable<DockerJobTemplateProperty> {
    public final String cloudname;
    public final DockerTemplate template;

    @DataBoundConstructor
    public DockerJobTemplateProperty(String cloudname, DockerTemplate template) {
        this.cloudname = cloudname;
        this.template = template;
    }

    @Exported
    public String getCloudname() {
        return this.cloudname;
    }

    @Exported
    public DockerTemplate getTemplate() {
        return this.template;
    }

    public Descriptor<DockerJobTemplateProperty> getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(DockerJobTemplateProperty.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerJobTemplateProperty> {
        public String getDisplayName() {
            return "Docker Job Image Property";
        }

        public FormValidation doCheckCloudname(@QueryParameter String cloudname) {
            if (DockerCloud.getCloudByName(cloudname) == null) {
                return FormValidation.error((String)"Cloud doesn't exists.", (Object[])new Object[]{cloudname});
            }
            return FormValidation.ok();
        }
    }
}

