/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.google.common.base.Strings;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerSimpleTemplate;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlCloudOption;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionDescriptor;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryToken;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderControlOptionRun
extends DockerBuilderControlCloudOption {
    private static final Logger LOG = LoggerFactory.getLogger(DockerBuilderControlOptionRun.class);
    public final String image;
    public final DockerRegistryEndpoint registry;
    public final String dnsString;
    public final String network;
    public final String dockerCommand;
    public final String volumesString;
    public final String volumesFrom;
    public final String environmentsString;
    public final String lxcConfString;
    public final boolean privileged;
    public final boolean tty;
    public final String hostname;
    public final String bindPorts;
    public final Integer memoryLimit;
    public final Integer memorySwap;
    public final Integer cpuShares;
    public final boolean bindAllPorts;
    public final String macAddress;

    @DataBoundConstructor
    public DockerBuilderControlOptionRun(String cloudName, String image, DockerRegistryEndpoint registry, String lxcConfString, String dnsString, String network, String dockerCommand, String volumesString, String volumesFrom, String environmentsString, String hostname, Integer memoryLimit, Integer memorySwap, Integer cpuShares, String bindPorts, boolean bindAllPorts, boolean privileged, boolean tty, String macAddress) {
        super(cloudName);
        this.image = image;
        this.registry = registry;
        this.lxcConfString = lxcConfString;
        this.dnsString = dnsString;
        this.network = network;
        this.dockerCommand = dockerCommand;
        this.volumesString = volumesString;
        this.volumesFrom = volumesFrom;
        this.environmentsString = environmentsString;
        this.privileged = privileged;
        this.tty = tty;
        this.hostname = hostname;
        this.bindPorts = bindPorts;
        this.memoryLimit = memoryLimit;
        this.memorySwap = memorySwap;
        this.cpuShares = cpuShares;
        this.bindAllPorts = bindAllPorts;
        this.macAddress = macAddress;
    }

    @Override
    public void execute(Run<?, ?> build, Launcher launcher, TaskListener listener) throws DockerException {
        final PrintStream llog = listener.getLogger();
        DockerClient client = this.getCloud(build, launcher).getClient();
        String xImage = this.expand(build, this.image);
        String xCommand = this.expand(build, this.dockerCommand);
        String xHostname = this.expand(build, this.hostname);
        LOG.info("Pulling image {}", (Object)xImage);
        llog.println("Pulling image " + xImage);
        PullImageResultCallback resultCallback = new PullImageResultCallback(){

            public void onNext(PullResponseItem item) {
                if (item.getStatus() != null && item.getProgress() == null) {
                    llog.print(item.getId() + ":" + item.getStatus());
                    LOG.info("{} : {}", (Object)item.getId(), (Object)item.getStatus());
                }
                super.onNext(item);
            }
        };
        PullImageCmd cmd = client.pullImageCmd(xImage);
        if (this.registry == null) {
            DockerRegistryToken token = this.registry.getToken(null);
            AuthConfig auth = new AuthConfig().withRegistryAddress(this.registry.getUrl()).withEmail(token.getEmail()).withRegistrytoken(token.getToken());
            cmd.withAuthConfig(auth);
        }
        ((PullImageResultCallback)cmd.exec((ResultCallback)resultCallback)).awaitSuccess();
        DockerSimpleTemplate template = new DockerSimpleTemplate(xImage, this.dnsString, this.network, xCommand, this.volumesString, this.volumesFrom, this.environmentsString, this.lxcConfString, xHostname, this.memoryLimit, this.memorySwap, this.cpuShares, this.bindPorts, this.bindAllPorts, this.privileged, this.tty, this.macAddress);
        LOG.info("Starting container for image {}", (Object)xImage);
        llog.println("Starting container for image " + xImage);
        String containerId = DockerCloud.runContainer(template, client, null);
        LOG.info("Started container {}", (Object)containerId);
        llog.println("Started container " + containerId);
        this.getLaunchAction(build).started(client, containerId);
    }

    private String expand(Run<?, ?> build, String text) {
        try {
            if (build instanceof AbstractBuild && !Strings.isNullOrEmpty((String)text)) {
                text = TokenMacro.expandAll((AbstractBuild)((AbstractBuild)build), (TaskListener)TaskListener.NULL, (String)text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Run Container";
        }
    }
}

