/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.client;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import com.nirima.jenkins.plugins.docker.client.DockerCmdExecConfig;
import org.apache.commons.lang.Validate;

public class ClientBuilderForPlugin {
    private DockerClientConfig config;
    private DockerCmdExecFactory dockerCmdExecFactory;

    private ClientBuilderForPlugin() {
    }

    private ClientBuilderForPlugin(DockerClientConfig config, DockerCmdExecFactory dockerCmdExecFactory) {
        this.config = config;
        this.dockerCmdExecFactory = dockerCmdExecFactory;
    }

    public ClientBuilderForPlugin withDockerCmdExecFactory(DockerCmdExecFactory dockerCmdExecFactory) {
        this.dockerCmdExecFactory = dockerCmdExecFactory;
        return this;
    }

    public ClientBuilderForPlugin withDockerCmdExecConfig(DockerCmdExecConfig config) {
        NettyDockerCmdExecFactory impl = new NettyDockerCmdExecFactory();
        this.dockerCmdExecFactory = impl;
        if (config.getConnectTimeoutMillis() != null) {
            impl.withConnectTimeout(config.getConnectTimeoutMillis());
        }
        return this;
    }

    public static ClientBuilderForPlugin builder() {
        return new ClientBuilderForPlugin();
    }

    public ClientBuilderForPlugin withDockerClientConfig(DockerClientConfig clientConfig) {
        this.config = clientConfig;
        return this;
    }

    public DockerClient build() {
        Validate.notNull((Object)this.config, (String)"ClientConfig must be set");
        Validate.notNull((Object)this.dockerCmdExecFactory, (String)"DockerCmdExecFactory must be set");
        return DockerClientBuilder.getInstance((DockerClientConfig)this.config).withDockerCmdExecFactory(this.dockerCmdExecFactory).build();
    }
}

