/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.client;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.KeystoreSSLConfig;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.util.CertificateUtils;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.client.ClientBuilderForPlugin;
import com.nirima.jenkins.plugins.docker.utils.DockerDirectoryCredentials;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;

public class ClientConfigBuilderForPlugin {
    private static final Logger LOGGER = Logger.getLogger(ClientConfigBuilderForPlugin.class.getName());
    private DefaultDockerClientConfig.Builder config = DefaultDockerClientConfig.createDefaultConfigBuilder();

    private ClientConfigBuilderForPlugin() {
    }

    public static ClientConfigBuilderForPlugin dockerClientConfig() {
        return new ClientConfigBuilderForPlugin();
    }

    public ClientConfigBuilderForPlugin forCloud(DockerCloud cloud) {
        LOGGER.log(Level.FINE, "Building connection to docker host \"{0}\" at: {1}", new Object[]{cloud.getDisplayName(), cloud.getServerUrl()});
        this.forServer(cloud.getDockerHost().getUri(), cloud.version);
        return this.withCredentials(cloud.getDockerHost().getCredentialsId());
    }

    public ClientConfigBuilderForPlugin forServer(String uri, @Nullable String version) {
        this.config.withDockerHost(URI.create(uri).toString()).withApiVersion(version);
        return this;
    }

    public ClientConfigBuilderForPlugin withCredentials(String credentialsId) {
        if (StringUtils.isNotBlank((String)credentialsId)) {
            Credentials credentials = ClientConfigBuilderForPlugin.lookupSystemCredentials(credentialsId);
            if (credentials instanceof DockerServerCredentials) {
                DockerServerCredentials c = (DockerServerCredentials)credentials;
                this.config.withCustomSslConfig((SSLConfig)new DockerServerCredentialsSSLConfig(c));
            } else if (credentials instanceof CertificateCredentials) {
                CertificateCredentials certificateCredentials = (CertificateCredentials)credentials;
                this.config.withCustomSslConfig((SSLConfig)new KeystoreSSLConfig(certificateCredentials.getKeyStore(), certificateCredentials.getPassword().getPlainText()));
            } else if (credentials instanceof DockerDirectoryCredentials) {
                DockerDirectoryCredentials ddc = (DockerDirectoryCredentials)credentials;
                this.config.withCustomSslConfig((SSLConfig)new LocalDirectorySSLConfig(ddc.getPath()));
            } else if (credentials instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials usernamePasswordCredentials = (StandardUsernamePasswordCredentials)credentials;
                this.config.withRegistryUsername(usernamePasswordCredentials.getUsername());
                this.config.withRegistryPassword(usernamePasswordCredentials.getPassword().getPlainText());
            }
        }
        return this;
    }

    public DockerClientConfig build() {
        return this.config.build();
    }

    public DockerClient buildClient() {
        return ClientBuilderForPlugin.builder().withDockerClientConfig(this.build()).build();
    }

    DefaultDockerClientConfig.Builder config() {
        return this.config;
    }

    private static Credentials lookupSystemCredentials(String credentialsId) {
        return CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(Credentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    private static class DockerServerCredentialsSSLConfig
    implements SSLConfig {
        private final DockerServerCredentials c;

        public DockerServerCredentialsSSLConfig(DockerServerCredentials c) {
            this.c = c;
        }

        public SSLContext getSSLContext() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
            try {
                KeyStore keyStore = CertificateUtils.createKeyStore((String)this.c.getClientKey(), (String)this.c.getClientCertificate());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, "docker".toCharArray());
                KeyStore trustStore = CertificateUtils.createTrustStore((String)this.c.getServerCaCertificate());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                return context;
            }
            catch (IOException | CertificateException | InvalidKeySpecException e) {
                throw new KeyStoreException("Can't build keystore from provided client key/certificate", e);
            }
        }
    }
}

