/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.launcher;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.Ports;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerLauncher;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.plugins.sshslaves.SSHConnector;
import hudson.util.ListBoxModel;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.logging.Logger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

@Beta
public class DockerComputerSSHLauncher
extends DockerComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(DockerComputerSSHLauncher.class.getName());
    protected final SSHConnector sshConnector;

    @DataBoundConstructor
    public DockerComputerSSHLauncher(SSHConnector sshConnector) {
        this.sshConnector = sshConnector;
    }

    public SSHConnector getSshConnector() {
        return this.sshConnector;
    }

    public InetSocketAddress getAddressForSSHD(DockerCloud cloud, InspectContainerResponse ir) {
        Ports.Binding[] sshBindings;
        ExposedPort sshPort = new ExposedPort(this.sshConnector.port);
        String host = null;
        Integer port = 22;
        NetworkSettings networkSettings = ir.getNetworkSettings();
        Ports ports = networkSettings.getPorts();
        Map bindings = ports.getBindings();
        for (Ports.Binding b : sshBindings = (Ports.Binding[])bindings.get(sshPort)) {
            String hps = b.getHostPortSpec();
            port = Integer.valueOf(hps);
            host = b.getHostIp();
        }
        if (host == null || host.equals("0.0.0.0")) {
            String url = cloud.getDockerHost().getUri();
            host = this.getDockerHostFromCloud(cloud);
            if (url.startsWith("unix") && (host == null || host.trim().isEmpty())) {
                host = "0.0.0.0";
            } else if (host == null || host.equals("0.0.0.0") || DockerComputerSSHLauncher.usesSingleHostAbstraction(ir)) {
                host = networkSettings.getIpAddress();
                port = this.sshConnector.port;
            }
        }
        return new InetSocketAddress(host, (int)port);
    }

    private String getDockerHostFromCloud(DockerCloud cloud) {
        String url = cloud.getDockerHost().getUri();
        String dockerHostname = cloud.getDockerHostname();
        if (dockerHostname != null && !dockerHostname.trim().isEmpty()) {
            return dockerHostname;
        }
        return URI.create(url).getHost();
    }

    protected static boolean usesSingleHostAbstraction(InspectContainerResponse inspect) {
        Preconditions.checkNotNull((Object)inspect);
        return inspect.getDriver().equals("sdc");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerComputerLauncher> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            return DockerTemplateBase.DescriptorImpl.doFillCredentialsIdItems(context);
        }

        public String getDisplayName() {
            return "Docker SSH computer launcher";
        }
    }
}

