/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.listener;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerJobProperty;
import com.nirima.jenkins.plugins.docker.DockerJobTemplateProperty;
import hudson.Extension;
import hudson.model.Project;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;

@Extension
public class DockerQueueListener
extends QueueListener {
    public void onEnterWaiting(Queue.WaitingItem wi) {
        DockerCloud cloud;
        DockerJobTemplateProperty jobTemplate = this.getJobTemplate((Queue.Item)wi);
        if (jobTemplate != null && (cloud = DockerCloud.getCloudByName(jobTemplate.getCloudname())) instanceof DockerCloud) {
            cloud.addJobTemplate(wi.getId(), jobTemplate.getTemplate());
        }
    }

    public void onLeft(Queue.LeftItem li) {
        DockerCloud cloud;
        DockerJobTemplateProperty jobTemplate = this.getJobTemplate((Queue.Item)li);
        if (jobTemplate != null && (cloud = DockerCloud.getCloudByName(jobTemplate.getCloudname())) instanceof DockerCloud) {
            cloud.removeJobTemplate(li.getId());
        }
    }

    private DockerJobTemplateProperty getJobTemplate(Queue.Item item) {
        DockerJobProperty property;
        Project project;
        if (item.task instanceof Project && (project = (Project)item.task) != null && (property = (DockerJobProperty)project.getProperty(DockerJobProperty.class)) != null) {
            return property.getDockerJobTemplate();
        }
        return null;
    }
}

