/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.core.command.AttachContainerResultCallback;
import com.google.common.annotations.Beta;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerComputer;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.Which;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import io.jenkins.docker.DockerSlaveProvisioner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import jenkins.model.Jenkins;

@Beta
public class AttachedDockerSlaveProvisioner
extends DockerSlaveProvisioner {
    private DockerSlave slave;
    private File remoting;
    private InputStream in;
    private OutputStream out;

    public AttachedDockerSlaveProvisioner(DockerCloud cloud, DockerTemplate template, DockerClient client) {
        super(cloud, template, client);
    }

    @Override
    public DockerSlave provision() throws IOException, Descriptor.FormException, InterruptedException {
        this.remoting = Which.jarFile(Channel.class);
        this.slave = new DockerSlave(this.cloud, this.template, new NoOpLauncher());
        Jenkins.getInstance().addNode((Node)this.slave);
        this.runContainer();
        DockerComputer computer = this.slave.getComputer();
        computer.setChannel(this.in, this.out, TaskListener.NULL, new Channel.Listener(){

            public void onClosed(Channel channel, IOException cause) {
            }
        });
        computer.setContainerId(this.container);
        return this.slave;
    }

    @Override
    protected void prepareCreateContainerCommand(CreateContainerCmd cmd) throws DockerException, IOException {
        cmd.withAttachStdin(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withStdinOpen(Boolean.valueOf(true)).withStdInOnce(Boolean.valueOf(true)).withLogConfig(new LogConfig(LogConfig.LoggingType.NONE)).withCmd(new String[]{"java", "-jar", this.template.remoteFs + '/' + this.remoting.getName()});
    }

    @Override
    protected void setupContainer() throws IOException, InterruptedException {
        this.client.copyArchiveToContainerCmd(this.container).withHostResource(this.remoting.getAbsolutePath()).withRemotePath(this.template.remoteFs).exec();
        PipedInputStream containerStdin = new PipedInputStream();
        this.out = new PipedOutputStream(containerStdin);
        final PipedOutputStream containerStdout = new PipedOutputStream();
        this.in = new PipedInputStream(containerStdout);
        AttachContainerResultCallback callback = new AttachContainerResultCallback(){

            public void onNext(Frame item) {
                switch (item.getStreamType()) {
                    case STDOUT: 
                    case RAW: {
                        try {
                            containerStdout.write(item.getPayload());
                            break;
                        }
                        catch (IOException e) {
                            throw new DockerException("Failed to collect stdout", 0, (Throwable)e);
                        }
                    }
                }
            }
        };
        this.client.attachContainerCmd(this.container).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdIn((InputStream)containerStdin).withFollowStream(Boolean.valueOf(true)).exec((ResultCallback)callback);
    }

    private static class NoOpLauncher
    extends ComputerLauncher {
        private NoOpLauncher() {
        }

        public void launch(SlaveComputer computer, TaskListener listener) {
        }
    }
}

