/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerImagePullStrategy;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import hudson.model.Descriptor;
import java.io.IOException;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DockerSlaveProvisioner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerSlaveProvisioner.class);
    protected final DockerCloud cloud;
    protected final DockerTemplate template;
    protected final DockerClient client;
    @CheckForNull
    protected String container;

    public DockerSlaveProvisioner(DockerCloud cloud, DockerTemplate template, DockerClient client) {
        this.cloud = cloud;
        this.template = template;
        this.client = client;
    }

    public abstract DockerSlave provision() throws IOException, Descriptor.FormException, InterruptedException;

    protected String runContainer() throws IOException, InterruptedException {
        this.pullImage();
        LOGGER.info("Trying to run container for {}", (Object)this.template.getImage());
        CreateContainerCmd cmd = this.client.createContainerCmd(this.template.getImage());
        this.template.fillContainerConfig(cmd);
        this.prepareCreateContainerCommand(cmd);
        this.container = cmd.exec().getId();
        try {
            this.setupContainer();
            this.client.startContainerCmd(this.container).exec();
        }
        catch (DockerException e) {
            this.client.removeContainerCmd(this.container).withForce(Boolean.valueOf(true)).exec();
            throw e;
        }
        return this.container;
    }

    protected void pullImage() {
        String image = this.template.getFullImageId();
        DockerImagePullStrategy strategy = this.template.getPullStrategy();
        if (strategy.shouldPullImage(this.client, image)) {
            LOGGER.info("Pulling image '{}'. This may take awhile...", (Object)image);
            long startTime = System.currentTimeMillis();
            PullImageCmd imgCmd = this.client.pullImageCmd(image);
            DockerRegistryEndpoint registry = this.template.getRegistry();
            if (registry == null) {
                DockerRegistryToken token = registry.getToken(null);
                AuthConfig auth = new AuthConfig().withRegistryAddress(registry.getUrl()).withEmail(token.getEmail()).withRegistrytoken(token.getToken());
                imgCmd.withAuthConfig(auth);
            }
            try {
                ((PullImageResultCallback)imgCmd.exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
            }
            catch (InterruptedException e) {
                throw new DockerClientException("Could not pull image: " + image, (Throwable)e);
            }
            try {
                this.client.inspectImageCmd(image).exec();
            }
            catch (NotFoundException e) {
                throw new DockerClientException("Could not pull image: " + image, (Throwable)e);
            }
            long pullTime = System.currentTimeMillis() - startTime;
            LOGGER.info("Finished pulling image '{}', took {} ms", (Object)image, (Object)pullTime);
        }
    }

    protected void prepareCreateContainerCommand(CreateContainerCmd cmd) throws DockerException, IOException {
    }

    protected void setupContainer() throws IOException, InterruptedException {
    }
}

