/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.nirima.docker.client.DockerClient;
import com.nirima.docker.client.DockerException;
import com.nirima.docker.client.model.Container;
import com.nirima.docker.client.model.ContainerInspectResponse;
import com.nirima.docker.client.model.ImageInspectResponse;
import com.nirima.docker.client.model.Version;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockerCloud
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(DockerCloud.class.getName());
    public static final String CLOUD_ID_PREFIX = "docker-";
    public final List<? extends DockerTemplate> templates;
    public final String serverUrl;
    private transient DockerClient connection;

    @DataBoundConstructor
    public DockerCloud(String name, List<? extends DockerTemplate> templates, String serverUrl, String instanceCapStr) {
        super(name);
        this.serverUrl = serverUrl;
        this.templates = templates != null ? templates : Collections.emptyList();
        this.readResolve();
    }

    protected Object readResolve() {
        for (DockerTemplate dockerTemplate : this.templates) {
            dockerTemplate.parent = this;
        }
        return this;
    }

    public synchronized DockerClient connect() {
        if (this.connection == null) {
            this.connection = DockerClient.builder().withUrl(this.serverUrl).build();
        }
        return this.connection;
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        try {
            LOGGER.log(Level.INFO, "Excess workload after pending Spot instances: " + excessWorkload);
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            final DockerTemplate t = this.getTemplate(label);
            while (excessWorkload > 0 && this.addProvisionedSlave(t.image, t.instanceCap)) {
                r.add(new NodeProvisioner.PlannedNode(t.getDisplayName(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                    @Override
                    public Node call() throws Exception {
                        try {
                            DockerSlave s = t.provision(new StreamTaskListener(System.out));
                            Jenkins.getInstance().addNode((Node)s);
                            s.toComputer().connect(false).get();
                            DockerSlave dockerSlave = s;
                            return dockerSlave;
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.WARNING, "Error in provisioning");
                            ex.printStackTrace();
                            throw Throwables.propagate((Throwable)ex);
                        }
                    }
                }), t.getNumExecutors()));
                excessWorkload -= t.getNumExecutors();
            }
            return r;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to count the # of live instances on Docker", e);
            return Collections.emptyList();
        }
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    public DockerTemplate getTemplate(String template) {
        for (DockerTemplate dockerTemplate : this.templates) {
            if (!dockerTemplate.image.equals(template)) continue;
            return dockerTemplate;
        }
        return null;
    }

    public DockerTemplate getTemplate(Label label) {
        for (DockerTemplate dockerTemplate : this.templates) {
            if (label != null && !label.matches(dockerTemplate.getLabelSet())) continue;
            return dockerTemplate;
        }
        return null;
    }

    private synchronized boolean addProvisionedSlave(String image, int amiCap) throws Exception {
        if (amiCap == 0) {
            return true;
        }
        final DockerClient dockerClient = this.connect();
        final ImageInspectResponse ir = dockerClient.image(image).inspect();
        List containers = dockerClient.containers().finder().allContainers(false).list();
        Collection matching = Collections2.filter((Collection)containers, (Predicate)new Predicate<Container>(){

            public boolean apply(@Nullable Container container) {
                ContainerInspectResponse cis = dockerClient.container(container.getId()).inspect();
                return cis.getImage().equalsIgnoreCase(ir.getId());
            }
        });
        return matching.size() < amiCap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Docker";
        }

        public FormValidation doTestConnection(@QueryParameter URL serverUrl) throws IOException, ServletException, DockerException {
            DockerClient dc = DockerClient.builder().withUrl(serverUrl.toString()).build();
            Version version = dc.system().version();
            return FormValidation.ok((String)("Version = " + version.getVersion()));
        }
    }
}

