/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.google.common.base.Objects;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockerComputer
extends AbstractCloudComputer<DockerSlave> {
    private static final Logger LOGGER = Logger.getLogger(DockerComputer.class.getName());
    private boolean haveWeRunAnyJobs = false;

    public DockerComputer(DockerSlave dockerSlave) {
        super((AbstractCloudSlave)dockerSlave);
    }

    public DockerCloud getCloud() {
        return ((DockerSlave)this.getNode()).getCloud();
    }

    public boolean haveWeRunAnyJobs() {
        return this.haveWeRunAnyJobs;
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        super.taskAccepted(executor, task);
        LOGGER.warning(" Computer " + (Object)((Object)this) + " taskAccepted");
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        super.taskCompleted(executor, task, durationMS);
        this.haveWeRunAnyJobs = true;
        Queue.Executable executable = executor.getCurrentExecutable();
        if (executable instanceof Run) {
            Run build = (Run)executable;
            ((DockerSlave)this.getNode()).setRun(build);
            if (((DockerSlave)this.getNode()).dockerTemplate.tagOnCompletion) {
                ((DockerSlave)this.getNode()).commitOnTerminate();
            }
        }
        LOGGER.log(Level.INFO, " Computer " + (Object)((Object)this) + " taskCompleted");
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        LOGGER.log(Level.INFO, " Computer " + (Object)((Object)this) + " taskCompletedWithProblems");
    }

    public boolean isAcceptingTasks() {
        boolean result = !this.haveWeRunAnyJobs && super.isAcceptingTasks();
        LOGGER.log(Level.INFO, " Computer " + (Object)((Object)this) + " isAcceptingTasks " + result);
        return result;
    }

    public void onConnected() {
        DockerSlave node = (DockerSlave)this.getNode();
        if (node != null) {
            node.onConnected();
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("name", (Object)super.getName()).add("slave", (Object)this.getNode()).toString();
    }
}

