/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.google.common.base.Preconditions;
import com.nirima.docker.client.model.ContainerInspectResponse;
import com.nirima.docker.client.model.Ports;
import com.nirima.jenkins.plugins.docker.DockerComputer;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.SSHConnector;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class DockerComputerLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(DockerComputerLauncher.class.getName());
    public final ContainerInspectResponse detail;
    public final DockerTemplate template;

    public DockerComputerLauncher(DockerTemplate template, ContainerInspectResponse containerInspectResponse) {
        Preconditions.checkNotNull((Object)template);
        Preconditions.checkNotNull((Object)containerInspectResponse);
        this.template = template;
        this.detail = containerInspectResponse;
    }

    public void launch(SlaveComputer _computer, TaskListener listener) throws IOException, InterruptedException {
        for (int tries = 0; tries < 3; ++tries) {
            SSHLauncher launcher = this.getSSHLauncher();
            launcher.launch(_computer, listener);
            if (launcher.getConnection() != null) {
                LOGGER.log(Level.INFO, "Launched " + _computer);
                return;
            }
            Thread.sleep(5000 * (tries + 1));
        }
        LOGGER.log(Level.WARNING, "Couldn't launch Docker template. Closing.");
        DockerComputer dc = (DockerComputer)_computer;
        ((DockerSlave)dc.getNode()).terminate();
    }

    public SSHLauncher getSSHLauncher() throws MalformedURLException {
        int port;
        try {
            port = Integer.parseInt(((Ports.Port)this.detail.getNetworkSettings().ports.getAllPorts().get("22")).getHostPort());
        }
        catch (NullPointerException ex) {
            throw new RuntimeException("No mapped port 22 in host for SSL. Config=" + this.detail);
        }
        URL hostUrl = new URL(this.template.getParent().serverUrl);
        String host = hostUrl.getHost();
        LOGGER.log(Level.INFO, "Creating slave SSH launcher for " + host + ":" + port);
        StandardUsernameCredentials credentials = SSHLauncher.lookupSystemCredentials((String)this.template.credentialsId);
        return new SSHLauncher(host, port, credentials, this.template.jvmOptions, this.template.javaPath, this.template.prefixStartSlaveCmd, this.template.suffixStartSlaveCmd, Integer.valueOf(60));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public String getDisplayName() {
            return "Docker SSH Launcher";
        }

        public Class getSshConnectorClass() {
            return SSHConnector.class;
        }

        public String getHelpFile(String fieldName) {
            String n = super.getHelpFile(fieldName);
            if (n == null) {
                n = Jenkins.getInstance().getDescriptor(SSHConnector.class).getHelpFile(fieldName);
            }
            return n;
        }
    }
}

